/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.sprite;

import org.andengine.entity.sprite.TiledSprite;
import org.andengine.input.touch.TouchEvent;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.texture.region.ITiledTextureRegion;
import org.andengine.opengl.texture.region.TiledTextureRegion;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.util.debug.Debug;

public class ButtonSprite
extends TiledSprite {
    private final int mStateCount;
    private OnClickListener mOnClickListener;
    private boolean mEnabled = true;
    private State mState;

    public ButtonSprite(float pX, float pY, ITextureRegion pNormalTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager) {
        this(pX, pY, pNormalTextureRegion, pVertexBufferObjectManager, (OnClickListener)null);
    }

    public ButtonSprite(float pX, float pY, ITextureRegion pNormalTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, OnClickListener pOnClickListener) {
        this(pX, pY, (ITiledTextureRegion)new TiledTextureRegion(pNormalTextureRegion.getTexture(), pNormalTextureRegion), pVertexBufferObjectManager, pOnClickListener);
    }

    public ButtonSprite(float pX, float pY, ITextureRegion pNormalTextureRegion, ITextureRegion pPressedTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager) {
        this(pX, pY, pNormalTextureRegion, pPressedTextureRegion, pVertexBufferObjectManager, (OnClickListener)null);
    }

    public ButtonSprite(float pX, float pY, ITextureRegion pNormalTextureRegion, ITextureRegion pPressedTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, OnClickListener pOnClickListener) {
        this(pX, pY, (ITiledTextureRegion)new TiledTextureRegion(pNormalTextureRegion.getTexture(), pNormalTextureRegion, pPressedTextureRegion), pVertexBufferObjectManager, pOnClickListener);
    }

    public ButtonSprite(float pX, float pY, ITextureRegion pNormalTextureRegion, ITextureRegion pPressedTextureRegion, ITextureRegion pDisabledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager) {
        this(pX, pY, pNormalTextureRegion, pPressedTextureRegion, pDisabledTextureRegion, pVertexBufferObjectManager, (OnClickListener)null);
    }

    public ButtonSprite(float pX, float pY, ITextureRegion pNormalTextureRegion, ITextureRegion pPressedTextureRegion, ITextureRegion pDisabledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, OnClickListener pOnClickListener) {
        this(pX, pY, (ITiledTextureRegion)new TiledTextureRegion(pNormalTextureRegion.getTexture(), pNormalTextureRegion, pPressedTextureRegion, pDisabledTextureRegion), pVertexBufferObjectManager, pOnClickListener);
    }

    public ButtonSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager) {
        this(pX, pY, pTiledTextureRegion, pVertexBufferObjectManager, (OnClickListener)null);
    }

    public ButtonSprite(float pX, float pY, ITiledTextureRegion pTiledTextureRegion, VertexBufferObjectManager pVertexBufferObjectManager, OnClickListener pOnClickListener) {
        super(pX, pY, pTiledTextureRegion, pVertexBufferObjectManager);
        this.mOnClickListener = pOnClickListener;
        this.mStateCount = pTiledTextureRegion.getTileCount();
        switch (this.mStateCount) {
            case 1: {
                Debug.w("No " + ITextureRegion.class.getSimpleName() + " supplied for " + State.class.getSimpleName() + "." + (Object)((Object)State.PRESSED) + ".");
            }
            case 2: {
                Debug.w("No " + ITextureRegion.class.getSimpleName() + " supplied for " + State.class.getSimpleName() + "." + (Object)((Object)State.DISABLED) + ".");
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The supplied " + ITiledTextureRegion.class.getSimpleName() + " has an unexpected amount of states: '" + this.mStateCount + "'.");
            }
        }
        this.changeState(State.NORMAL);
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean pEnabled) {
        this.mEnabled = pEnabled;
        if (this.mEnabled && this.mState == State.DISABLED) {
            this.changeState(State.NORMAL);
        } else if (!this.mEnabled) {
            this.changeState(State.DISABLED);
        }
    }

    public boolean isPressed() {
        return this.mState == State.PRESSED;
    }

    public State getState() {
        return this.mState;
    }

    public void setOnClickListener(OnClickListener pOnClickListener) {
        this.mOnClickListener = pOnClickListener;
    }

    @Override
    public boolean onAreaTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
        if (!this.isEnabled()) {
            this.changeState(State.DISABLED);
        } else if (pSceneTouchEvent.isActionDown()) {
            this.changeState(State.PRESSED);
        } else if (pSceneTouchEvent.isActionCancel() || !this.contains(pSceneTouchEvent.getX(), pSceneTouchEvent.getY())) {
            this.changeState(State.NORMAL);
        } else if (pSceneTouchEvent.isActionUp() && this.mState == State.PRESSED) {
            this.changeState(State.NORMAL);
            if (this.mOnClickListener != null) {
                this.mOnClickListener.onClick(this, pTouchAreaLocalX, pTouchAreaLocalY);
            }
        }
        return true;
    }

    @Override
    public boolean contains(float pX, float pY) {
        if (!this.isVisible()) {
            return false;
        }
        return super.contains(pX, pY);
    }

    private void changeState(State pState) {
        if (pState == this.mState) {
            return;
        }
        this.mState = pState;
        int stateTiledTextureRegionIndex = this.mState.getTiledTextureRegionIndex();
        if (stateTiledTextureRegionIndex >= this.mStateCount) {
            this.setCurrentTileIndex(0);
            Debug.w(this.getClass().getSimpleName() + " changed its " + State.class.getSimpleName() + " to " + pState.toString() + ", which doesn't have a " + ITextureRegion.class.getSimpleName() + " supplied. Applying default " + ITextureRegion.class.getSimpleName() + ".");
        } else {
            this.setCurrentTileIndex(stateTiledTextureRegionIndex);
        }
    }

    public static enum State {
        NORMAL(0),
        PRESSED(1),
        DISABLED(2);

        private final int mTiledTextureRegionIndex;

        private State(int pTiledTextureRegionIndex) {
            this.mTiledTextureRegionIndex = pTiledTextureRegionIndex;
        }

        public int getTiledTextureRegionIndex() {
            return this.mTiledTextureRegionIndex;
        }
    }

    public static interface OnClickListener {
        public void onClick(ButtonSprite var1, float var2, float var3);
    }
}

