/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.util;

import org.andengine.entity.util.AverageFPSCounter;

public class FPSLogger
extends AverageFPSCounter {
    protected float mShortestFrame = Float.MAX_VALUE;
    protected float mLongestFrame = Float.MIN_VALUE;

    public FPSLogger() {
    }

    public FPSLogger(float pAverageDuration) {
        super(pAverageDuration);
    }

    @Override
    protected void onHandleAverageDurationElapsed(float pFPS) {
        this.onLogFPS();
        this.mLongestFrame = Float.MIN_VALUE;
        this.mShortestFrame = Float.MAX_VALUE;
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        super.onUpdate(pSecondsElapsed);
        this.mShortestFrame = Math.min(this.mShortestFrame, pSecondsElapsed);
        this.mLongestFrame = Math.max(this.mLongestFrame, pSecondsElapsed);
    }

    @Override
    public void reset() {
        super.reset();
        this.mShortestFrame = Float.MAX_VALUE;
        this.mLongestFrame = Float.MIN_VALUE;
    }

    protected void onLogFPS() {
    }
}

