/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.util;

import android.graphics.Bitmap;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.andengine.engine.camera.Camera;
import org.andengine.entity.Entity;
import org.andengine.entity.util.ScreenGrabber;
import org.andengine.opengl.util.GLState;
import org.andengine.util.StreamUtils;
import org.andengine.util.debug.Debug;

public class ScreenCapture
extends Entity
implements ScreenGrabber.IScreenGrabberCallback {
    private String mFilePath;
    private final ScreenGrabber mScreenGrabber = new ScreenGrabber();
    private IScreenCaptureCallback mScreenCaptureCallback;

    @Override
    protected void onManagedDraw(GLState pGLState, Camera pCamera) {
        this.mScreenGrabber.onManagedDraw(pGLState, pCamera);
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void onScreenGrabbed(Bitmap pBitmap) {
        try {
            ScreenCapture.saveCapture(pBitmap, this.mFilePath);
            this.mScreenCaptureCallback.onScreenCaptured(this.mFilePath);
        }
        catch (FileNotFoundException e) {
            this.mScreenCaptureCallback.onScreenCaptureFailed(this.mFilePath, e);
        }
    }

    @Override
    public void onScreenGrabFailed(Exception pException) {
        this.mScreenCaptureCallback.onScreenCaptureFailed(this.mFilePath, pException);
    }

    public void capture(int pCaptureWidth, int pCaptureHeight, String pFilePath, IScreenCaptureCallback pScreenCaptureCallback) {
        this.capture(0, 0, pCaptureWidth, pCaptureHeight, pFilePath, pScreenCaptureCallback);
    }

    public void capture(int pCaptureX, int pCaptureY, int pCaptureWidth, int pCaptureHeight, String pFilePath, IScreenCaptureCallback pScreencaptureCallback) {
        this.mFilePath = pFilePath;
        this.mScreenCaptureCallback = pScreencaptureCallback;
        this.mScreenGrabber.grab(pCaptureX, pCaptureY, pCaptureWidth, pCaptureHeight, this);
    }

    private static void saveCapture(Bitmap pBitmap, String pFilePath) throws FileNotFoundException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(pFilePath);
            pBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            StreamUtils.flushCloseStream(out);
            Debug.e("Error saving file to: " + pFilePath, e);
            throw e;
        }
    }

    public static interface IScreenCaptureCallback {
        public void onScreenCaptured(String var1);

        public void onScreenCaptureFailed(String var1, Exception var2);
    }
}

