/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.entity.util;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.IntBuffer;
import org.andengine.engine.camera.Camera;
import org.andengine.entity.Entity;
import org.andengine.opengl.util.GLState;

public class ScreenGrabber
extends Entity {
    private int mGrabX;
    private int mGrabY;
    private int mGrabWidth;
    private int mGrabHeight;
    private boolean mScreenGrabPending = false;
    private IScreenGrabberCallback mScreenGrabCallback;

    @Override
    protected void onManagedDraw(GLState pGLState, Camera pCamera) {
        if (this.mScreenGrabPending) {
            try {
                Bitmap screenGrab = ScreenGrabber.grab(this.mGrabX, this.mGrabY, this.mGrabWidth, this.mGrabHeight);
                this.mScreenGrabCallback.onScreenGrabbed(screenGrab);
            }
            catch (Exception e) {
                this.mScreenGrabCallback.onScreenGrabFailed(e);
            }
            this.mScreenGrabPending = false;
        }
    }

    @Override
    protected void onManagedUpdate(float pSecondsElapsed) {
    }

    @Override
    public void reset() {
    }

    public void grab(int pGrabWidth, int pGrabHeight, IScreenGrabberCallback pScreenGrabCallback) {
        this.grab(0, 0, pGrabWidth, pGrabHeight, pScreenGrabCallback);
    }

    public void grab(int pGrabX, int pGrabY, int pGrabWidth, int pGrabHeight, IScreenGrabberCallback pScreenGrabCallback) {
        this.mGrabX = pGrabX;
        this.mGrabY = pGrabY;
        this.mGrabWidth = pGrabWidth;
        this.mGrabHeight = pGrabHeight;
        this.mScreenGrabCallback = pScreenGrabCallback;
        this.mScreenGrabPending = true;
    }

    private static Bitmap grab(int pGrabX, int pGrabY, int pGrabWidth, int pGrabHeight) {
        int[] source = new int[pGrabWidth * (pGrabY + pGrabHeight)];
        IntBuffer sourceBuffer = IntBuffer.wrap(source);
        sourceBuffer.position(0);
        GLES20.glReadPixels((int)pGrabX, (int)0, (int)pGrabWidth, (int)(pGrabY + pGrabHeight), (int)6408, (int)5121, (Buffer)sourceBuffer);
        int[] pixels = new int[pGrabWidth * pGrabHeight];
        for (int y = 0; y < pGrabHeight; ++y) {
            for (int x = 0; x < pGrabWidth; ++x) {
                int pixel = source[x + (pGrabY + y) * pGrabWidth];
                int blue = (pixel & 0xFF0000) >> 16;
                int red = (pixel & 0xFF) << 16;
                int greenAlpha = pixel & 0xFF00FF00;
                pixels[x + (pGrabHeight - y - 1) * pGrabWidth] = greenAlpha | red | blue;
            }
        }
        return Bitmap.createBitmap((int[])pixels, (int)pGrabWidth, (int)pGrabHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static interface IScreenGrabberCallback {
        public void onScreenGrabbed(Bitmap var1);

        public void onScreenGrabFailed(Exception var1);
    }
}

