/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.sensor.orientation;

import android.hardware.SensorManager;
import java.util.Arrays;
import org.andengine.input.sensor.BaseSensorData;

public class OrientationData
extends BaseSensorData {
    private final float[] mAccelerationValues = new float[3];
    private final float[] mMagneticFieldValues = new float[3];
    private final float[] mRotationMatrix = new float[16];
    private int mMagneticFieldAccuracy;

    public OrientationData(int pDisplayRotation) {
        super(3, pDisplayRotation);
    }

    public float getRoll() {
        return this.mValues[2];
    }

    public float getPitch() {
        return this.mValues[1];
    }

    public float getYaw() {
        return this.mValues[0];
    }

    @Override
    @Deprecated
    public void setValues(float[] pValues) {
        super.setValues(pValues);
    }

    @Override
    @Deprecated
    public void setAccuracy(int pAccuracy) {
        super.setAccuracy(pAccuracy);
    }

    public void setAccelerationValues(float[] pValues) {
        System.arraycopy(pValues, 0, this.mAccelerationValues, 0, pValues.length);
        this.updateOrientation();
    }

    public void setMagneticFieldValues(float[] pValues) {
        System.arraycopy(pValues, 0, this.mMagneticFieldValues, 0, pValues.length);
        this.updateOrientation();
    }

    private void updateOrientation() {
        SensorManager.getRotationMatrix((float[])this.mRotationMatrix, null, (float[])this.mAccelerationValues, (float[])this.mMagneticFieldValues);
        switch (this.mDisplayRotation) {
            case 0: {
                break;
            }
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.mRotationMatrix, (int)2, (int)129, (float[])this.mRotationMatrix);
            }
        }
        float[] values = this.mValues;
        SensorManager.getOrientation((float[])this.mRotationMatrix, (float[])values);
        for (int i = values.length - 1; i >= 0; --i) {
            values[i] = values[i] * 57.295776f;
        }
    }

    public int getAccelerationAccuracy() {
        return this.getAccuracy();
    }

    public void setAccelerationAccuracy(int pAccelerationAccuracy) {
        super.setAccuracy(pAccelerationAccuracy);
    }

    public int getMagneticFieldAccuracy() {
        return this.mMagneticFieldAccuracy;
    }

    public void setMagneticFieldAccuracy(int pMagneticFieldAccuracy) {
        this.mMagneticFieldAccuracy = pMagneticFieldAccuracy;
    }

    @Override
    public String toString() {
        return "Orientation: " + Arrays.toString(this.mValues);
    }
}

