/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.controller;

import android.view.MotionEvent;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.controller.ITouchController;
import org.andengine.input.touch.controller.ITouchEventCallback;
import org.andengine.util.adt.pool.RunnablePoolItem;
import org.andengine.util.adt.pool.RunnablePoolUpdateHandler;

public abstract class BaseTouchController
implements ITouchController {
    private ITouchEventCallback mTouchEventCallback;
    private final RunnablePoolUpdateHandler<TouchEventRunnablePoolItem> mTouchEventRunnablePoolUpdateHandler = new RunnablePoolUpdateHandler<TouchEventRunnablePoolItem>(){

        @Override
        protected TouchEventRunnablePoolItem onAllocatePoolItem() {
            return new TouchEventRunnablePoolItem();
        }
    };

    @Override
    public void setTouchEventCallback(ITouchEventCallback pTouchEventCallback) {
        this.mTouchEventCallback = pTouchEventCallback;
    }

    @Override
    public void reset() {
        this.mTouchEventRunnablePoolUpdateHandler.reset();
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        this.mTouchEventRunnablePoolUpdateHandler.onUpdate(pSecondsElapsed);
    }

    protected void fireTouchEvent(float pX, float pY, int pAction, int pPointerID, MotionEvent pMotionEvent) {
        TouchEvent touchEvent = TouchEvent.obtain(pX, pY, pAction, pPointerID, MotionEvent.obtain((MotionEvent)pMotionEvent));
        TouchEventRunnablePoolItem touchEventRunnablePoolItem = (TouchEventRunnablePoolItem)this.mTouchEventRunnablePoolUpdateHandler.obtainPoolItem();
        touchEventRunnablePoolItem.set(touchEvent);
        this.mTouchEventRunnablePoolUpdateHandler.postPoolItem(touchEventRunnablePoolItem);
    }

    class TouchEventRunnablePoolItem
    extends RunnablePoolItem {
        private TouchEvent mTouchEvent;

        TouchEventRunnablePoolItem() {
        }

        public void set(TouchEvent pTouchEvent) {
            this.mTouchEvent = pTouchEvent;
        }

        @Override
        public void run() {
            BaseTouchController.this.mTouchEventCallback.onTouchEvent(this.mTouchEvent);
        }

        @Override
        protected void onRecycle() {
            super.onRecycle();
            TouchEvent touchEvent = this.mTouchEvent;
            touchEvent.getMotionEvent().recycle();
            touchEvent.recycle();
        }
    }
}

