/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.controller;

import android.view.MotionEvent;
import org.andengine.input.touch.controller.BaseTouchController;

public class MultiTouchController
extends BaseTouchController {
    @Override
    public void onHandleMotionEvent(MotionEvent pMotionEvent) {
        int action = pMotionEvent.getAction() & 0xFF;
        switch (action) {
            case 0: 
            case 5: {
                this.onHandleTouchAction(0, pMotionEvent);
                return;
            }
            case 1: 
            case 6: {
                this.onHandleTouchAction(1, pMotionEvent);
                return;
            }
            case 3: 
            case 4: {
                this.onHandleTouchAction(action, pMotionEvent);
                return;
            }
            case 2: {
                this.onHandleTouchMove(pMotionEvent);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Action detected: " + action);
    }

    private void onHandleTouchMove(MotionEvent pMotionEvent) {
        int i = pMotionEvent.getPointerCount() - 1;
        while (i >= 0) {
            int pointerIndex = i--;
            int pointerID = pMotionEvent.getPointerId(pointerIndex);
            this.fireTouchEvent(pMotionEvent.getX(pointerIndex), pMotionEvent.getY(pointerIndex), 2, pointerID, pMotionEvent);
        }
    }

    private void onHandleTouchAction(int pAction, MotionEvent pMotionEvent) {
        int pointerIndex = MultiTouchController.getPointerIndex(pMotionEvent);
        int pointerID = pMotionEvent.getPointerId(pointerIndex);
        this.fireTouchEvent(pMotionEvent.getX(pointerIndex), pMotionEvent.getY(pointerIndex), pAction, pointerID, pMotionEvent);
    }

    private static int getPointerIndex(MotionEvent pMotionEvent) {
        return (pMotionEvent.getAction() & 0xFF00) >> 8;
    }
}

