/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.detector;

import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.BaseDetector;

public class ClickDetector
extends BaseDetector {
    private static final long TRIGGER_CLICK_MAXIMUM_MILLISECONDS_DEFAULT = 200L;
    private long mTriggerClickMaximumMilliseconds;
    private final IClickDetectorListener mClickDetectorListener;
    private int mPointerID = -1;
    private long mDownTimeMilliseconds = Long.MIN_VALUE;

    public ClickDetector(IClickDetectorListener pClickDetectorListener) {
        this(200L, pClickDetectorListener);
    }

    public ClickDetector(long pTriggerClickMaximumMilliseconds, IClickDetectorListener pClickDetectorListener) {
        this.mTriggerClickMaximumMilliseconds = pTriggerClickMaximumMilliseconds;
        this.mClickDetectorListener = pClickDetectorListener;
    }

    public long getTriggerClickMaximumMilliseconds() {
        return this.mTriggerClickMaximumMilliseconds;
    }

    public void setTriggerClickMaximumMilliseconds(long pClickMaximumMilliseconds) {
        this.mTriggerClickMaximumMilliseconds = pClickMaximumMilliseconds;
    }

    @Override
    public void reset() {
        this.mDownTimeMilliseconds = Long.MIN_VALUE;
        this.mPointerID = -1;
    }

    @Override
    public boolean onManagedTouchEvent(TouchEvent pSceneTouchEvent) {
        switch (pSceneTouchEvent.getAction()) {
            case 0: {
                this.prepareClick(pSceneTouchEvent);
                return true;
            }
            case 1: 
            case 3: {
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    boolean handled = false;
                    long upTimeMilliseconds = pSceneTouchEvent.getMotionEvent().getEventTime();
                    if (upTimeMilliseconds - this.mDownTimeMilliseconds <= this.mTriggerClickMaximumMilliseconds) {
                        this.mDownTimeMilliseconds = Long.MIN_VALUE;
                        this.mClickDetectorListener.onClick(this, pSceneTouchEvent.getPointerID(), pSceneTouchEvent.getX(), pSceneTouchEvent.getY());
                        handled = true;
                    }
                    this.mPointerID = -1;
                    return handled;
                }
                return false;
            }
        }
        return false;
    }

    private void prepareClick(TouchEvent pSceneTouchEvent) {
        this.mDownTimeMilliseconds = pSceneTouchEvent.getMotionEvent().getDownTime();
        this.mPointerID = pSceneTouchEvent.getPointerID();
    }

    public static interface IClickDetectorListener {
        public void onClick(ClickDetector var1, int var2, float var3, float var4);
    }
}

