/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.detector;

import android.view.MotionEvent;
import org.andengine.engine.handler.IUpdateHandler;
import org.andengine.engine.handler.timer.ITimerCallback;
import org.andengine.engine.handler.timer.TimerHandler;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.HoldDetector;

public class ContinuousHoldDetector
extends HoldDetector
implements IUpdateHandler {
    private static final float TIME_BETWEEN_UPDATES_DEFAULT = 0.1f;
    private final TimerHandler mTimerHandler;

    public ContinuousHoldDetector(HoldDetector.IHoldDetectorListener pHoldDetectorListener) {
        this(200L, 10.0f, 0.1f, pHoldDetectorListener);
    }

    public ContinuousHoldDetector(long pTriggerHoldMinimumMilliseconds, float pTriggerHoldMaximumDistance, float pTimeBetweenUpdates, HoldDetector.IHoldDetectorListener pHoldDetectorListener) {
        super(pTriggerHoldMinimumMilliseconds, pTriggerHoldMaximumDistance, pHoldDetectorListener);
        this.mTimerHandler = new TimerHandler(pTimeBetweenUpdates, true, new ITimerCallback(){

            @Override
            public void onTimePassed(TimerHandler pTimerHandler) {
                ContinuousHoldDetector.this.fireListener();
            }
        });
    }

    @Override
    public void onUpdate(float pSecondsElapsed) {
        this.mTimerHandler.onUpdate(pSecondsElapsed);
    }

    @Override
    public void reset() {
        super.reset();
        this.mTimerHandler.reset();
    }

    @Override
    public boolean onManagedTouchEvent(TouchEvent pSceneTouchEvent) {
        MotionEvent motionEvent = pSceneTouchEvent.getMotionEvent();
        switch (pSceneTouchEvent.getAction()) {
            case 0: {
                if (this.mPointerID == -1) {
                    this.prepareHold(pSceneTouchEvent);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    this.mHoldX = pSceneTouchEvent.getX();
                    this.mHoldY = pSceneTouchEvent.getY();
                    this.mMaximumDistanceExceeded = this.mMaximumDistanceExceeded || Math.abs(this.mDownX - motionEvent.getX()) > this.mTriggerHoldMaximumDistance || Math.abs(this.mDownY - motionEvent.getY()) > this.mTriggerHoldMaximumDistance;
                    return true;
                }
                return false;
            }
            case 1: 
            case 3: {
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    this.mHoldX = pSceneTouchEvent.getX();
                    this.mHoldY = pSceneTouchEvent.getY();
                    if (this.mTriggering) {
                        this.triggerOnHoldFinished(motionEvent.getEventTime() - this.mDownTimeMilliseconds);
                    }
                    this.mPointerID = -1;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    protected void prepareHold(TouchEvent pSceneTouchEvent) {
        super.prepareHold(pSceneTouchEvent);
        this.mTimerHandler.reset();
    }

    void fireListener() {
        long holdTimeMilliseconds;
        if (this.mPointerID != -1 && (holdTimeMilliseconds = System.currentTimeMillis() - this.mDownTimeMilliseconds) >= this.mTriggerHoldMinimumMilliseconds) {
            if (this.mTriggering) {
                this.triggerOnHold(holdTimeMilliseconds);
            } else if (!this.mMaximumDistanceExceeded) {
                this.triggerOnHoldStarted();
            }
        }
    }
}

