/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.detector;

import android.view.MotionEvent;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.BaseDetector;

public class HoldDetector
extends BaseDetector {
    protected static final long TRIGGER_HOLD_MINIMUM_MILLISECONDS_DEFAULT = 200L;
    protected static final float TRIGGER_HOLD_MAXIMUM_DISTANCE_DEFAULT = 10.0f;
    protected long mTriggerHoldMinimumMilliseconds;
    protected float mTriggerHoldMaximumDistance;
    protected final IHoldDetectorListener mHoldDetectorListener;
    protected int mPointerID = -1;
    protected long mDownTimeMilliseconds = Long.MIN_VALUE;
    protected float mDownX;
    protected float mDownY;
    protected float mHoldX;
    protected float mHoldY;
    protected boolean mMaximumDistanceExceeded;
    protected boolean mTriggering;

    public HoldDetector(IHoldDetectorListener pHoldDetectorListener) {
        this(200L, 10.0f, pHoldDetectorListener);
    }

    public HoldDetector(long pTriggerHoldMinimumMilliseconds, float pTriggerHoldMaximumDistance, IHoldDetectorListener pHoldDetectorListener) {
        this.setTriggerHoldMinimumMilliseconds(pTriggerHoldMinimumMilliseconds);
        this.setTriggerHoldMaximumDistance(pTriggerHoldMaximumDistance);
        this.mHoldDetectorListener = pHoldDetectorListener;
    }

    public long getTriggerHoldMinimumMilliseconds() {
        return this.mTriggerHoldMinimumMilliseconds;
    }

    public void setTriggerHoldMinimumMilliseconds(long pTriggerHoldMinimumMilliseconds) {
        if (pTriggerHoldMinimumMilliseconds < 0L) {
            throw new IllegalArgumentException("pTriggerHoldMinimumMilliseconds must not be < 0.");
        }
        this.mTriggerHoldMinimumMilliseconds = pTriggerHoldMinimumMilliseconds;
    }

    public float getTriggerHoldMaximumDistance() {
        return this.mTriggerHoldMaximumDistance;
    }

    public void setTriggerHoldMaximumDistance(float pTriggerHoldMaximumDistance) {
        if (pTriggerHoldMaximumDistance < 0.0f) {
            throw new IllegalArgumentException("pTriggerHoldMaximumDistance must not be < 0.");
        }
        this.mTriggerHoldMaximumDistance = pTriggerHoldMaximumDistance;
    }

    public boolean isHolding() {
        return this.mTriggering;
    }

    @Override
    public void reset() {
        if (this.mTriggering) {
            this.triggerOnHoldFinished(System.currentTimeMillis() - this.mDownTimeMilliseconds);
        }
        this.mTriggering = false;
        this.mMaximumDistanceExceeded = false;
        this.mDownTimeMilliseconds = Long.MIN_VALUE;
        this.mPointerID = -1;
    }

    @Override
    public boolean onManagedTouchEvent(TouchEvent pSceneTouchEvent) {
        MotionEvent motionEvent = pSceneTouchEvent.getMotionEvent();
        switch (pSceneTouchEvent.getAction()) {
            case 0: {
                if (this.mPointerID == -1) {
                    this.prepareHold(pSceneTouchEvent);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    this.mHoldX = pSceneTouchEvent.getX();
                    this.mHoldY = pSceneTouchEvent.getY();
                    long holdTimeMilliseconds = System.currentTimeMillis() - this.mDownTimeMilliseconds;
                    if (holdTimeMilliseconds >= this.mTriggerHoldMinimumMilliseconds) {
                        if (this.mTriggering) {
                            this.triggerOnHold(holdTimeMilliseconds);
                        } else {
                            float triggerHoldMaximumDistance = this.mTriggerHoldMaximumDistance;
                            boolean bl = this.mMaximumDistanceExceeded = this.mMaximumDistanceExceeded || Math.abs(this.mDownX - motionEvent.getX()) > triggerHoldMaximumDistance || Math.abs(this.mDownY - motionEvent.getY()) > triggerHoldMaximumDistance;
                            if (!this.mMaximumDistanceExceeded) {
                                if (!this.mTriggering) {
                                    this.triggerOnHoldStarted();
                                } else {
                                    this.triggerOnHold(holdTimeMilliseconds);
                                }
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
            case 1: 
            case 3: {
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    this.mHoldX = pSceneTouchEvent.getX();
                    this.mHoldY = pSceneTouchEvent.getY();
                    long holdTimeMilliseconds = System.currentTimeMillis() - this.mDownTimeMilliseconds;
                    if (holdTimeMilliseconds >= this.mTriggerHoldMinimumMilliseconds) {
                        if (this.mTriggering) {
                            this.triggerOnHoldFinished(holdTimeMilliseconds);
                        } else {
                            float triggerHoldMaximumDistance = this.mTriggerHoldMaximumDistance;
                            boolean bl = this.mMaximumDistanceExceeded = this.mMaximumDistanceExceeded || Math.abs(this.mDownX - motionEvent.getX()) > triggerHoldMaximumDistance || Math.abs(this.mDownY - motionEvent.getY()) > triggerHoldMaximumDistance;
                            if (!this.mMaximumDistanceExceeded) {
                                this.triggerOnHoldFinished(holdTimeMilliseconds);
                            }
                        }
                    }
                    this.mPointerID = -1;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected void prepareHold(TouchEvent pSceneTouchEvent) {
        MotionEvent motionEvent = pSceneTouchEvent.getMotionEvent();
        this.mDownTimeMilliseconds = System.currentTimeMillis();
        this.mDownX = motionEvent.getX();
        this.mDownY = motionEvent.getY();
        this.mMaximumDistanceExceeded = false;
        this.mPointerID = pSceneTouchEvent.getPointerID();
        this.mHoldX = pSceneTouchEvent.getX();
        this.mHoldY = pSceneTouchEvent.getY();
        if (this.mTriggerHoldMinimumMilliseconds == 0L) {
            this.triggerOnHoldStarted();
        }
    }

    protected void triggerOnHoldStarted() {
        this.mTriggering = true;
        if (this.mPointerID != -1) {
            this.mHoldDetectorListener.onHoldStarted(this, this.mPointerID, this.mHoldX, this.mHoldY);
        }
    }

    protected void triggerOnHold(long pHoldTimeMilliseconds) {
        if (this.mPointerID != -1) {
            this.mHoldDetectorListener.onHold(this, pHoldTimeMilliseconds, this.mPointerID, this.mHoldX, this.mHoldY);
        }
    }

    protected void triggerOnHoldFinished(long pHoldTimeMilliseconds) {
        this.mTriggering = false;
        if (this.mPointerID != -1) {
            this.mHoldDetectorListener.onHoldFinished(this, pHoldTimeMilliseconds, this.mPointerID, this.mHoldX, this.mHoldY);
        }
    }

    public static interface IHoldDetectorListener {
        public void onHoldStarted(HoldDetector var1, int var2, float var3, float var4);

        public void onHold(HoldDetector var1, long var2, int var4, float var5, float var6);

        public void onHoldFinished(HoldDetector var1, long var2, int var4, float var5, float var6);
    }
}

