/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.detector;

import android.view.MotionEvent;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.BaseDetector;
import org.andengine.util.math.MathUtils;

public class PinchZoomDetector
extends BaseDetector {
    private static final float TRIGGER_PINCHZOOM_MINIMUM_DISTANCE_DEFAULT = 10.0f;
    private final IPinchZoomDetectorListener mPinchZoomDetectorListener;
    private float mInitialDistance;
    private float mCurrentDistance;
    private boolean mPinchZooming;

    public PinchZoomDetector(IPinchZoomDetectorListener pPinchZoomDetectorListener) {
        this.mPinchZoomDetectorListener = pPinchZoomDetectorListener;
    }

    public boolean isZooming() {
        return this.mPinchZooming;
    }

    @Override
    public void reset() {
        if (this.mPinchZooming) {
            this.mPinchZoomDetectorListener.onPinchZoomFinished(this, null, this.getZoomFactor());
        }
        this.mInitialDistance = 0.0f;
        this.mCurrentDistance = 0.0f;
        this.mPinchZooming = false;
    }

    @Override
    public boolean onManagedTouchEvent(TouchEvent pSceneTouchEvent) {
        MotionEvent motionEvent = pSceneTouchEvent.getMotionEvent();
        int action = motionEvent.getAction() & 0xFF;
        switch (action) {
            case 5: {
                if (this.mPinchZooming || !PinchZoomDetector.hasTwoOrMorePointers(motionEvent)) break;
                this.mCurrentDistance = this.mInitialDistance = PinchZoomDetector.calculatePointerDistance(motionEvent);
                if (!(this.mInitialDistance > 10.0f)) break;
                this.mPinchZooming = true;
                this.mPinchZoomDetectorListener.onPinchZoomStarted(this, pSceneTouchEvent);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                if (!this.mPinchZooming) break;
                this.mPinchZooming = false;
                this.mPinchZoomDetectorListener.onPinchZoomFinished(this, pSceneTouchEvent, this.getZoomFactor());
                break;
            }
            case 2: {
                if (!this.mPinchZooming) break;
                if (PinchZoomDetector.hasTwoOrMorePointers(motionEvent)) {
                    this.mCurrentDistance = PinchZoomDetector.calculatePointerDistance(motionEvent);
                    if (!(this.mCurrentDistance > 10.0f)) break;
                    this.mPinchZoomDetectorListener.onPinchZoom(this, pSceneTouchEvent, this.getZoomFactor());
                    break;
                }
                this.mPinchZooming = false;
                this.mPinchZoomDetectorListener.onPinchZoomFinished(this, pSceneTouchEvent, this.getZoomFactor());
            }
        }
        return true;
    }

    private float getZoomFactor() {
        return this.mCurrentDistance / this.mInitialDistance;
    }

    private static float calculatePointerDistance(MotionEvent pMotionEvent) {
        return MathUtils.distance(pMotionEvent.getX(0), pMotionEvent.getY(0), pMotionEvent.getX(1), pMotionEvent.getY(1));
    }

    private static boolean hasTwoOrMorePointers(MotionEvent pMotionEvent) {
        return pMotionEvent.getPointerCount() >= 2;
    }

    public static interface IPinchZoomDetectorListener {
        public void onPinchZoomStarted(PinchZoomDetector var1, TouchEvent var2);

        public void onPinchZoom(PinchZoomDetector var1, TouchEvent var2, float var3);

        public void onPinchZoomFinished(PinchZoomDetector var1, TouchEvent var2, float var3);
    }
}

