/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.detector;

import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.BaseDetector;

public class ScrollDetector
extends BaseDetector {
    private static final float TRIGGER_SCROLL_MINIMUM_DISTANCE_DEFAULT = 10.0f;
    private float mTriggerScrollMinimumDistance;
    private final IScrollDetectorListener mScrollDetectorListener;
    private int mPointerID = -1;
    private boolean mTriggering;
    private float mLastX;
    private float mLastY;

    public ScrollDetector(IScrollDetectorListener pScrollDetectorListener) {
        this(10.0f, pScrollDetectorListener);
    }

    public ScrollDetector(float pTriggerScrollMinimumDistance, IScrollDetectorListener pScrollDetectorListener) {
        this.mTriggerScrollMinimumDistance = pTriggerScrollMinimumDistance;
        this.mScrollDetectorListener = pScrollDetectorListener;
    }

    public float getTriggerScrollMinimumDistance() {
        return this.mTriggerScrollMinimumDistance;
    }

    public void setTriggerScrollMinimumDistance(float pTriggerScrollMinimumDistance) {
        this.mTriggerScrollMinimumDistance = pTriggerScrollMinimumDistance;
    }

    @Override
    public void reset() {
        if (this.mTriggering) {
            this.mScrollDetectorListener.onScrollFinished(this, this.mPointerID, 0.0f, 0.0f);
        }
        this.mLastX = 0.0f;
        this.mLastY = 0.0f;
        this.mTriggering = false;
        this.mPointerID = -1;
    }

    @Override
    public boolean onManagedTouchEvent(TouchEvent pSceneTouchEvent) {
        float touchX = this.getX(pSceneTouchEvent);
        float touchY = this.getY(pSceneTouchEvent);
        switch (pSceneTouchEvent.getAction()) {
            case 0: {
                this.prepareScroll(pSceneTouchEvent.getPointerID(), touchX, touchY);
                return true;
            }
            case 2: {
                if (this.mPointerID == -1) {
                    this.prepareScroll(pSceneTouchEvent.getPointerID(), touchX, touchY);
                    return true;
                }
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    float distanceX = touchX - this.mLastX;
                    float distanceY = touchY - this.mLastY;
                    float triggerScrollMinimumDistance = this.mTriggerScrollMinimumDistance;
                    if (this.mTriggering || Math.abs(distanceX) > triggerScrollMinimumDistance || Math.abs(distanceY) > triggerScrollMinimumDistance) {
                        if (!this.mTriggering) {
                            this.triggerOnScrollStarted(distanceX, distanceY);
                        } else {
                            this.triggerOnScroll(distanceX, distanceY);
                        }
                        this.mLastX = touchX;
                        this.mLastY = touchY;
                        this.mTriggering = true;
                    }
                    return true;
                }
                return false;
            }
            case 1: 
            case 3: {
                if (this.mPointerID == pSceneTouchEvent.getPointerID()) {
                    float distanceX = touchX - this.mLastX;
                    float distanceY = touchY - this.mLastY;
                    if (this.mTriggering) {
                        this.triggerOnScrollFinished(distanceX, distanceY);
                    }
                    this.mPointerID = -1;
                }
                return true;
            }
        }
        return false;
    }

    private void prepareScroll(int pPointerID, float pTouchX, float pTouchY) {
        this.mLastX = pTouchX;
        this.mLastY = pTouchY;
        this.mTriggering = false;
        this.mPointerID = pPointerID;
    }

    private void triggerOnScrollStarted(float pDistanceX, float pDistanceY) {
        if (this.mPointerID != -1) {
            this.mScrollDetectorListener.onScrollStarted(this, this.mPointerID, pDistanceX, pDistanceY);
        }
    }

    private void triggerOnScroll(float pDistanceX, float pDistanceY) {
        if (this.mPointerID != -1) {
            this.mScrollDetectorListener.onScroll(this, this.mPointerID, pDistanceX, pDistanceY);
        }
    }

    private void triggerOnScrollFinished(float pDistanceX, float pDistanceY) {
        this.mTriggering = false;
        if (this.mPointerID != -1) {
            this.mScrollDetectorListener.onScrollFinished(this, this.mPointerID, pDistanceX, pDistanceY);
        }
    }

    protected float getX(TouchEvent pTouchEvent) {
        return pTouchEvent.getX();
    }

    protected float getY(TouchEvent pTouchEvent) {
        return pTouchEvent.getY();
    }

    public static interface IScrollDetectorListener {
        public void onScrollStarted(ScrollDetector var1, int var2, float var3, float var4);

        public void onScroll(ScrollDetector var1, int var2, float var3, float var4);

        public void onScrollFinished(ScrollDetector var1, int var2, float var3, float var4);
    }
}

