/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.input.touch.detector;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import org.andengine.input.touch.TouchEvent;
import org.andengine.input.touch.detector.BaseDetector;

public abstract class SurfaceGestureDetector
extends BaseDetector {
    private static final float SWIPE_MIN_DISTANCE_DEFAULT = 120.0f;
    private final GestureDetector mGestureDetector;

    public SurfaceGestureDetector(Context pContext) {
        this(pContext, 120.0f);
    }

    public SurfaceGestureDetector(Context pContext, float pSwipeMinDistance) {
        this.mGestureDetector = new GestureDetector(pContext, (GestureDetector.OnGestureListener)new InnerOnGestureDetectorListener(pSwipeMinDistance));
    }

    protected abstract boolean onSingleTap();

    protected abstract boolean onDoubleTap();

    protected abstract boolean onSwipeUp();

    protected abstract boolean onSwipeDown();

    protected abstract boolean onSwipeLeft();

    protected abstract boolean onSwipeRight();

    @Override
    public void reset() {
    }

    @Override
    public boolean onManagedTouchEvent(TouchEvent pSceneTouchEvent) {
        return this.mGestureDetector.onTouchEvent(pSceneTouchEvent.getMotionEvent());
    }

    private class InnerOnGestureDetectorListener
    extends GestureDetector.SimpleOnGestureListener {
        private final float mSwipeMinDistance;

        public InnerOnGestureDetectorListener(float pSwipeMinDistance) {
            this.mSwipeMinDistance = pSwipeMinDistance;
        }

        public boolean onSingleTapConfirmed(MotionEvent pMotionEvent) {
            return SurfaceGestureDetector.this.onSingleTap();
        }

        public boolean onDoubleTap(MotionEvent pMotionEvent) {
            return SurfaceGestureDetector.this.onDoubleTap();
        }

        public boolean onFling(MotionEvent pMotionEventStart, MotionEvent pMotionEventEnd, float pVelocityX, float pVelocityY) {
            boolean isHorizontalFling;
            float swipeMinDistance = this.mSwipeMinDistance;
            boolean bl = isHorizontalFling = Math.abs(pVelocityX) > Math.abs(pVelocityY);
            if (isHorizontalFling) {
                if (pMotionEventStart.getX() - pMotionEventEnd.getX() > swipeMinDistance) {
                    return SurfaceGestureDetector.this.onSwipeLeft();
                }
                if (pMotionEventEnd.getX() - pMotionEventStart.getX() > swipeMinDistance) {
                    return SurfaceGestureDetector.this.onSwipeRight();
                }
            } else {
                if (pMotionEventStart.getY() - pMotionEventEnd.getY() > swipeMinDistance) {
                    return SurfaceGestureDetector.this.onSwipeUp();
                }
                if (pMotionEventEnd.getY() - pMotionEventStart.getY() > swipeMinDistance) {
                    return SurfaceGestureDetector.this.onSwipeDown();
                }
            }
            return false;
        }
    }
}

