/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl;

import android.opengl.GLES20;
import org.andengine.util.exception.AndEngineRuntimeException;
import org.andengine.util.system.SystemUtils;

public class GLES20Fix {
    private static boolean NATIVE_LIB_LOADED;
    private static final boolean WORKAROUND_MISSING_GLES20_METHODS;

    private GLES20Fix() {
    }

    public static native void glVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, int var5);

    public static native void glDrawElements(int var0, int var1, int var2, int var3);

    public static void glVertexAttribPointerFix(int pIndex, int pSize, int pType, boolean pNormalized, int pStride, int pOffset) {
        if (WORKAROUND_MISSING_GLES20_METHODS) {
            GLES20Fix.glVertexAttribPointerFix(pIndex, pSize, pType, pNormalized, pStride, pOffset);
        } else {
            GLES20.glVertexAttribPointer((int)pIndex, (int)pSize, (int)pType, (boolean)pNormalized, (int)pStride, (int)pOffset);
        }
    }

    public static void glDrawElementsFix(int pMode, int pCount, int pType, int pOffset) {
        if (WORKAROUND_MISSING_GLES20_METHODS) {
            GLES20Fix.glDrawElements(pMode, pCount, pType, pOffset);
        } else {
            GLES20.glDrawElements((int)pMode, (int)pCount, (int)pType, (int)pOffset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        boolean loadLibrarySuccess;
        try {
            System.loadLibrary("andengine");
            loadLibrarySuccess = true;
        }
        catch (UnsatisfiedLinkError e) {
            loadLibrarySuccess = false;
        }
        NATIVE_LIB_LOADED = loadLibrarySuccess;
        if (SystemUtils.isAndroidVersionOrLower(8)) {
            if (!loadLibrarySuccess) throw new AndEngineRuntimeException("Inherently incompatible device detected.");
            WORKAROUND_MISSING_GLES20_METHODS = true;
            return;
        } else {
            WORKAROUND_MISSING_GLES20_METHODS = false;
        }
    }
}

