/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.font;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.SparseArray;
import java.util.ArrayList;
import org.andengine.opengl.font.FontManager;
import org.andengine.opengl.font.IFont;
import org.andengine.opengl.font.Letter;
import org.andengine.opengl.font.exception.FontException;
import org.andengine.opengl.texture.ITexture;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.util.GLState;
import org.andengine.util.adt.map.SparseArrayUtils;
import org.andengine.util.color.Color;
import org.andengine.util.math.MathUtils;

public class Font
implements IFont {
    protected static final int LETTER_TEXTURE_PADDING = 1;
    private final FontManager mFontManager;
    private final ITexture mTexture;
    private final int mTextureWidth;
    private final int mTextureHeight;
    private int mCurrentTextureX = 1;
    private int mCurrentTextureY = 1;
    private int mCurrentTextureYHeightMax;
    private final SparseArray<Letter> mManagedCharacterToLetterMap = new SparseArray();
    private final ArrayList<Letter> mLettersPendingToBeDrawnToTexture = new ArrayList();
    protected final Paint mPaint;
    private final Paint mBackgroundPaint;
    protected final Paint.FontMetrics mFontMetrics;
    protected final Canvas mCanvas = new Canvas();
    protected final Rect mTextBounds = new Rect();
    protected final float[] mTextWidthContainer = new float[1];

    public Font(FontManager pFontManager, ITexture pTexture, Typeface pTypeface, float pSize, boolean pAntiAlias, Color pColor) {
        this(pFontManager, pTexture, pTypeface, pSize, pAntiAlias, pColor.getARGBPackedInt());
    }

    public Font(FontManager pFontManager, ITexture pTexture, Typeface pTypeface, float pSize, boolean pAntiAlias, int pColorARGBPackedInt) {
        this.mFontManager = pFontManager;
        this.mTexture = pTexture;
        this.mTextureWidth = pTexture.getWidth();
        this.mTextureHeight = pTexture.getHeight();
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setColor(Color.TRANSPARENT_ARGB_PACKED_INT);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mPaint = new Paint();
        this.mPaint.setTypeface(pTypeface);
        this.mPaint.setColor(pColorARGBPackedInt);
        this.mPaint.setTextSize(pSize);
        this.mPaint.setAntiAlias(pAntiAlias);
        this.mFontMetrics = this.mPaint.getFontMetrics();
    }

    public float getLeading() {
        return this.mFontMetrics.leading;
    }

    public float getAscent() {
        return this.mFontMetrics.ascent;
    }

    public float getDescent() {
        return this.mFontMetrics.descent;
    }

    @Override
    public ITexture getTexture() {
        return this.mTexture;
    }

    @Override
    public void load() {
        this.mTexture.load();
        this.mFontManager.loadFont(this);
    }

    @Override
    public void unload() {
        this.mTexture.unload();
        this.mFontManager.unloadFont(this);
    }

    @Override
    public float getLineHeight() {
        return -this.getAscent() + this.getDescent();
    }

    @Override
    public synchronized Letter getLetter(char pCharacter) throws FontException {
        Letter letter = (Letter)this.mManagedCharacterToLetterMap.get((int)pCharacter);
        if (letter == null) {
            letter = this.createLetter(pCharacter);
            this.mLettersPendingToBeDrawnToTexture.add(letter);
            this.mManagedCharacterToLetterMap.put((int)pCharacter, (Object)letter);
        }
        return letter;
    }

    public synchronized void invalidateLetters() {
        ArrayList<Letter> lettersPendingToBeDrawnToTexture = this.mLettersPendingToBeDrawnToTexture;
        SparseArray<Letter> managedCharacterToLetterMap = this.mManagedCharacterToLetterMap;
        for (int i = managedCharacterToLetterMap.size() - 1; i >= 0; --i) {
            lettersPendingToBeDrawnToTexture.add((Letter)managedCharacterToLetterMap.valueAt(i));
        }
    }

    private float getLetterAdvance(String pCharacterAsString) {
        this.mPaint.getTextWidths(pCharacterAsString, this.mTextWidthContainer);
        return this.mTextWidthContainer[0];
    }

    protected Bitmap getLetterBitmap(Letter pLetter) throws FontException {
        char character = pLetter.mCharacter;
        String characterAsString = String.valueOf(character);
        int width = pLetter.mWidth + 2;
        int height = pLetter.mHeight + 2;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas.setBitmap(bitmap);
        this.mCanvas.drawRect(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight(), this.mBackgroundPaint);
        float drawLetterLeft = -pLetter.mOffsetX;
        float drawLetterTop = -(pLetter.mOffsetY + this.getAscent());
        this.drawLetter(characterAsString, drawLetterLeft, drawLetterTop);
        return bitmap;
    }

    protected void drawLetter(String pCharacterAsString, float pLeft, float pTop) {
        this.mCanvas.drawText(pCharacterAsString, pLeft + 1.0f, pTop + 1.0f, this.mPaint);
    }

    public void prepareLetters(char ... pCharacters) throws FontException {
        for (char character : pCharacters) {
            this.getLetter(character);
        }
    }

    private Letter createLetter(char pCharacter) throws FontException {
        Letter letter;
        boolean whitespace;
        String characterAsString = String.valueOf(pCharacter);
        float textureWidth = this.mTextureWidth;
        float textureHeight = this.mTextureHeight;
        this.updateTextBounds(characterAsString);
        int letterLeft = this.mTextBounds.left;
        int letterTop = this.mTextBounds.top;
        int letterWidth = this.mTextBounds.width();
        int letterHeight = this.mTextBounds.height();
        float advance = this.getLetterAdvance(characterAsString);
        boolean bl = whitespace = Character.isWhitespace(pCharacter) || letterWidth == 0 || letterHeight == 0;
        if (whitespace) {
            letter = new Letter(pCharacter, advance);
        } else {
            if ((float)(this.mCurrentTextureX + 1 + letterWidth) >= textureWidth) {
                this.mCurrentTextureX = 0;
                this.mCurrentTextureY += this.mCurrentTextureYHeightMax + 2;
                this.mCurrentTextureYHeightMax = 0;
            }
            if ((float)(this.mCurrentTextureY + letterHeight) >= textureHeight) {
                throw new FontException("Not enough space for " + Letter.class.getSimpleName() + ": '" + pCharacter + "' on the " + this.mTexture.getClass().getSimpleName() + ". Existing Letters: " + SparseArrayUtils.toString(this.mManagedCharacterToLetterMap));
            }
            this.mCurrentTextureYHeightMax = Math.max(letterHeight, this.mCurrentTextureYHeightMax);
            ++this.mCurrentTextureX;
            float u = (float)this.mCurrentTextureX / textureWidth;
            float v = (float)this.mCurrentTextureY / textureHeight;
            float u2 = (float)(this.mCurrentTextureX + letterWidth) / textureWidth;
            float v2 = (float)(this.mCurrentTextureY + letterHeight) / textureHeight;
            letter = new Letter(pCharacter, this.mCurrentTextureX - 1, this.mCurrentTextureY - 1, letterWidth, letterHeight, letterLeft, (float)letterTop - this.getAscent(), advance, u, v, u2, v2);
            this.mCurrentTextureX += letterWidth + 1;
        }
        return letter;
    }

    protected void updateTextBounds(String pCharacterAsString) {
        this.mPaint.getTextBounds(pCharacterAsString, 0, 1, this.mTextBounds);
    }

    public synchronized void update(GLState pGLState) {
        ArrayList<Letter> lettersPendingToBeDrawnToTexture;
        if (this.mTexture.isLoadedToHardware() && (lettersPendingToBeDrawnToTexture = this.mLettersPendingToBeDrawnToTexture).size() > 0) {
            this.mTexture.bind(pGLState);
            PixelFormat pixelFormat = this.mTexture.getPixelFormat();
            boolean preMultipyAlpha = this.mTexture.getTextureOptions().mPreMultiplyAlpha;
            for (int i = lettersPendingToBeDrawnToTexture.size() - 1; i >= 0; --i) {
                boolean useDefaultAlignment;
                Letter letter = lettersPendingToBeDrawnToTexture.get(i);
                if (letter.isWhitespace()) continue;
                Bitmap bitmap = this.getLetterBitmap(letter);
                boolean bl = useDefaultAlignment = MathUtils.isPowerOfTwo(bitmap.getWidth()) && MathUtils.isPowerOfTwo(bitmap.getHeight()) && pixelFormat == PixelFormat.RGBA_8888;
                if (!useDefaultAlignment) {
                    GLES20.glPixelStorei((int)3317, (int)1);
                }
                if (preMultipyAlpha) {
                    GLUtils.texSubImage2D((int)3553, (int)0, (int)letter.mTextureX, (int)letter.mTextureY, (Bitmap)bitmap);
                } else {
                    pGLState.glTexSubImage2D(3553, 0, letter.mTextureX, letter.mTextureY, bitmap, pixelFormat);
                }
                if (!useDefaultAlignment) {
                    GLES20.glPixelStorei((int)3317, (int)4);
                }
                bitmap.recycle();
            }
            lettersPendingToBeDrawnToTexture.clear();
            System.gc();
        }
    }
}

