/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.font;

import java.util.List;
import org.andengine.entity.text.AutoWrap;
import org.andengine.opengl.font.IFont;
import org.andengine.opengl.font.Letter;
import org.andengine.util.TextUtils;
import org.andengine.util.exception.MethodNotYetImplementedException;

public class FontUtils {
    private static final int UNSPECIFIED = -1;

    public static float measureText(IFont pFont, CharSequence pText) {
        return FontUtils.measureText(pFont, pText, null);
    }

    public static float measureText(IFont pFont, CharSequence pText, int pStart, int pEnd) {
        return FontUtils.measureText(pFont, pText, pStart, pEnd, null);
    }

    public static float measureText(IFont pFont, CharSequence pText, float[] pWidths) {
        return FontUtils.measureText(pFont, pText, 0, pText.length(), pWidths);
    }

    public static float measureText(IFont pFont, CharSequence pText, int pStart, int pEnd, float[] pWidths) {
        int textLength = pEnd - pStart;
        if (pStart == pEnd) {
            return 0.0f;
        }
        if (textLength == 1) {
            return pFont.getLetter((char)pText.charAt((int)pStart)).mWidth;
        }
        Letter previousLetter = null;
        float width = 0.0f;
        int pos = pStart;
        int i = 0;
        while (pos < pEnd) {
            Letter letter = pFont.getLetter(pText.charAt(pos));
            if (previousLetter != null) {
                width += (float)previousLetter.getKerning(letter.mCharacter);
            }
            previousLetter = letter;
            width = pos == pEnd - 1 ? (width += letter.mOffsetX + (float)letter.mWidth) : (width += letter.mAdvance);
            if (pWidths != null) {
                pWidths[i] = width;
            }
            ++pos;
            ++i;
        }
        return width;
    }

    public static int breakText(IFont pFont, CharSequence pText, MeasureDirection pMeasureDirection, float pWidthMaximum, float[] pMeasuredWidth) {
        throw new MethodNotYetImplementedException();
    }

    public static <L extends List<CharSequence>> L splitLines(CharSequence pText, L pResult) {
        return TextUtils.split(pText, '\n', pResult);
    }

    public static <L extends List<CharSequence>> L splitLines(IFont pFont, CharSequence pText, L pResult, AutoWrap pAutoWrap, float pAutoWrapWidth) {
        switch (pAutoWrap) {
            case LETTERS: {
                return FontUtils.splitLinesByLetters(pFont, pText, pResult, pAutoWrapWidth);
            }
            case WORDS: {
                return FontUtils.splitLinesByWords(pFont, pText, pResult, pAutoWrapWidth);
            }
            case CJK: {
                return FontUtils.splitLinesByCJK(pFont, pText, pResult, pAutoWrapWidth);
            }
        }
        throw new IllegalArgumentException("Unexpected " + AutoWrap.class.getSimpleName() + ": '" + (Object)((Object)pAutoWrap) + "'.");
    }

    private static <L extends List<CharSequence>> L splitLinesByLetters(IFont pFont, CharSequence pText, L pResult, float pAutoWrapWidth) {
        int textLength = pText.length();
        int lineStart = 0;
        int lineEnd = 0;
        int lastNonWhitespace = 0;
        boolean charsAvailable = false;
        for (int i = 0; i < textLength; ++i) {
            boolean isEndReached;
            char character = pText.charAt(i);
            if (character != ' ') {
                if (charsAvailable) {
                    lastNonWhitespace = i + 1;
                } else {
                    charsAvailable = true;
                    lineStart = i;
                    lineEnd = lastNonWhitespace = lineStart + 1;
                }
            }
            if (!charsAvailable) continue;
            float lookaheadLineWidth = FontUtils.measureText(pFont, pText, lineStart, lastNonWhitespace);
            boolean bl = isEndReached = i == textLength - 1;
            if (isEndReached) {
                if (lookaheadLineWidth <= pAutoWrapWidth) {
                    pResult.add((CharSequence)pText.subSequence(lineStart, lastNonWhitespace));
                    continue;
                }
                pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
                if (lineStart == i) continue;
                pResult.add((CharSequence)pText.subSequence(i, lastNonWhitespace));
                continue;
            }
            if (lookaheadLineWidth <= pAutoWrapWidth) {
                lineEnd = lastNonWhitespace;
                continue;
            }
            pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
            i = lineEnd - 1;
            charsAvailable = false;
        }
        return pResult;
    }

    private static <L extends List<CharSequence>> L splitLinesByWords(IFont pFont, CharSequence pText, L pResult, float pAutoWrapWidth) {
        int textLength = pText.length();
        if (textLength == 0) {
            return pResult;
        }
        float spaceWidth = pFont.getLetter((char)' ').mAdvance;
        int lastWordEnd = -1;
        int lineStart = -1;
        int lineEnd = -1;
        float lineWidthRemaining = pAutoWrapWidth;
        boolean firstWordInLine = true;
        int i = 0;
        while (i < textLength) {
            int spacesSkipped = 0;
            while (i < textLength && pText.charAt(i) == ' ') {
                ++i;
                ++spacesSkipped;
            }
            int wordStart = i;
            if (lineStart == -1) {
                lineStart = wordStart;
            }
            while (i < textLength && pText.charAt(i) != ' ') {
                ++i;
            }
            int wordEnd = i;
            if (wordStart == wordEnd) {
                if (firstWordInLine) break;
                pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
                break;
            }
            float wordWidth = FontUtils.measureText(pFont, pText, wordStart, wordEnd);
            float widthNeeded = firstWordInLine ? wordWidth : (float)spacesSkipped * spaceWidth + wordWidth;
            if (widthNeeded <= lineWidthRemaining) {
                if (firstWordInLine) {
                    firstWordInLine = false;
                } else {
                    lineWidthRemaining -= FontUtils.getAdvanceCorrection(pFont, pText, lastWordEnd - 1);
                }
                lineWidthRemaining -= widthNeeded;
                lastWordEnd = wordEnd;
                lineEnd = wordEnd;
                if (wordEnd != textLength) continue;
                pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
                break;
            }
            if (firstWordInLine) {
                if (wordWidth >= pAutoWrapWidth) {
                    pResult.add((CharSequence)pText.subSequence(wordStart, wordEnd));
                    lineWidthRemaining = pAutoWrapWidth;
                } else {
                    lineWidthRemaining = pAutoWrapWidth - wordWidth;
                    if (wordEnd == textLength) {
                        pResult.add((CharSequence)pText.subSequence(wordStart, wordEnd));
                        break;
                    }
                }
                firstWordInLine = true;
                lastWordEnd = -1;
                lineStart = -1;
                lineEnd = -1;
                continue;
            }
            pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
            if (wordEnd == textLength) {
                pResult.add((CharSequence)pText.subSequence(wordStart, wordEnd));
                break;
            }
            lineWidthRemaining = pAutoWrapWidth - wordWidth;
            firstWordInLine = false;
            lastWordEnd = wordEnd;
            lineStart = wordStart;
            lineEnd = wordEnd;
        }
        return pResult;
    }

    private static <L extends List<CharSequence>> L splitLinesByCJK(IFont pFont, CharSequence pText, L pResult, float pAutoWrapWidth) {
        int textLength = pText.length();
        int lineStart = 0;
        int lineEnd = 0;
        while (lineStart < textLength && pText.charAt(lineStart) == ' ') {
            ++lineStart;
            ++lineEnd;
        }
        int i = lineEnd;
        while (i < textLength) {
            lineStart = lineEnd;
            boolean charsAvailable = true;
            while (i < textLength) {
                float lineWidth;
                int j;
                for (j = lineEnd; j < textLength && pText.charAt(j) == ' '; ++j) {
                }
                if (j == textLength) {
                    if (lineStart == lineEnd) {
                        charsAvailable = false;
                    }
                    i = textLength;
                    break;
                }
                if ((lineWidth = FontUtils.measureText(pFont, pText, lineStart, ++lineEnd)) > pAutoWrapWidth) {
                    if (lineStart < lineEnd - 1) {
                        --lineEnd;
                    }
                    pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
                    charsAvailable = false;
                    i = lineEnd;
                    break;
                }
                i = lineEnd;
            }
            if (!charsAvailable) continue;
            pResult.add((CharSequence)pText.subSequence(lineStart, lineEnd));
        }
        return pResult;
    }

    private static float getAdvanceCorrection(IFont pFont, CharSequence pText, int pIndex) {
        Letter lastWordLastLetter = pFont.getLetter(pText.charAt(pIndex));
        return -(lastWordLastLetter.mOffsetX + (float)lastWordLastLetter.mWidth) + lastWordLastLetter.mAdvance;
    }

    public static enum MeasureDirection {
        FORWARDS,
        BACKWARDS;

    }
}

