/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.shader;

import android.opengl.GLES20;
import org.andengine.opengl.shader.ShaderProgram;
import org.andengine.opengl.shader.exception.ShaderProgramLinkException;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.vbo.attribute.VertexBufferObjectAttributes;

public class PositionTextureCoordinatesShaderProgram
extends ShaderProgram {
    private static PositionTextureCoordinatesShaderProgram INSTANCE;
    public static final String VERTEXSHADER = "uniform mat4 u_modelViewProjectionMatrix;\nattribute vec4 a_position;\nattribute vec2 a_textureCoordinates;\nvarying vec2 v_textureCoordinates;\nvoid main() {\n\tv_textureCoordinates = a_textureCoordinates;\n\tgl_Position = u_modelViewProjectionMatrix * a_position;\n}";
    public static final String FRAGMENTSHADER = "precision lowp float;\nuniform sampler2D u_texture_0;\nvarying mediump vec2 v_textureCoordinates;\nvoid main() {\n\tgl_FragColor = texture2D(u_texture_0, v_textureCoordinates);\n}";
    public static int sUniformModelViewPositionMatrixLocation;
    public static int sUniformTexture0Location;

    private PositionTextureCoordinatesShaderProgram() {
        super(VERTEXSHADER, FRAGMENTSHADER);
    }

    public static PositionTextureCoordinatesShaderProgram getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PositionTextureCoordinatesShaderProgram();
        }
        return INSTANCE;
    }

    @Override
    protected void link(GLState pGLState) throws ShaderProgramLinkException {
        GLES20.glBindAttribLocation((int)this.mProgramID, (int)0, (String)"a_position");
        GLES20.glBindAttribLocation((int)this.mProgramID, (int)3, (String)"a_textureCoordinates");
        super.link(pGLState);
        sUniformModelViewPositionMatrixLocation = this.getUniformLocation("u_modelViewProjectionMatrix");
        sUniformTexture0Location = this.getUniformLocation("u_texture_0");
    }

    @Override
    public void bind(GLState pGLState, VertexBufferObjectAttributes pVertexBufferObjectAttributes) {
        GLES20.glDisableVertexAttribArray((int)1);
        super.bind(pGLState, pVertexBufferObjectAttributes);
        GLES20.glUniformMatrix4fv((int)sUniformModelViewPositionMatrixLocation, (int)1, (boolean)false, (float[])pGLState.getModelViewProjectionGLMatrix(), (int)0);
        GLES20.glUniform1i((int)sUniformTexture0Location, (int)0);
    }

    @Override
    public void unbind(GLState pGLState) {
        GLES20.glEnableVertexAttribArray((int)1);
        super.unbind(pGLState);
    }

    static {
        sUniformModelViewPositionMatrixLocation = -1;
        sUniformTexture0Location = -1;
    }
}

