/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.shader;

import android.opengl.GLES20;
import java.util.HashMap;
import org.andengine.opengl.shader.exception.ShaderProgramCompileException;
import org.andengine.opengl.shader.exception.ShaderProgramException;
import org.andengine.opengl.shader.exception.ShaderProgramLinkException;
import org.andengine.opengl.shader.source.IShaderSource;
import org.andengine.opengl.shader.source.StringShaderSource;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.vbo.attribute.VertexBufferObjectAttributes;

public class ShaderProgram {
    private static final int[] HARDWAREID_CONTAINER = new int[1];
    private static final int[] PARAMETERS_CONTAINER = new int[1];
    private static final int[] LENGTH_CONTAINER = new int[1];
    private static final int[] SIZE_CONTAINER = new int[1];
    private static final int[] TYPE_CONTAINER = new int[1];
    private static final int NAME_CONTAINER_SIZE = 64;
    private static final byte[] NAME_CONTAINER = new byte[64];
    protected final IShaderSource mVertexShaderSource;
    protected final IShaderSource mFragmentShaderSource;
    protected int mProgramID = -1;
    protected boolean mCompiled;
    protected final HashMap<String, Integer> mUniformLocations = new HashMap();
    protected final HashMap<String, Integer> mAttributeLocations = new HashMap();

    public ShaderProgram(String pVertexShaderSource, String pFragmentShaderSource) {
        this(new StringShaderSource(pVertexShaderSource), new StringShaderSource(pFragmentShaderSource));
    }

    public ShaderProgram(IShaderSource pVertexShaderSource, IShaderSource pFragmentShaderSource) {
        this.mVertexShaderSource = pVertexShaderSource;
        this.mFragmentShaderSource = pFragmentShaderSource;
    }

    public boolean isCompiled() {
        return this.mCompiled;
    }

    public void setCompiled(boolean pCompiled) {
        this.mCompiled = pCompiled;
    }

    public int getAttributeLocation(String pAttributeName) {
        Integer location = this.mAttributeLocations.get(pAttributeName);
        if (location != null) {
            return location;
        }
        throw new ShaderProgramException("Unexpected attribute: '" + pAttributeName + "'. Existing attributes: " + this.mAttributeLocations.toString());
    }

    public int getAttributeLocationOptional(String pAttributeName) {
        Integer location = this.mAttributeLocations.get(pAttributeName);
        if (location != null) {
            return location;
        }
        return -1;
    }

    public int getUniformLocation(String pUniformName) {
        Integer location = this.mUniformLocations.get(pUniformName);
        if (location != null) {
            return location;
        }
        throw new ShaderProgramException("Unexpected uniform: '" + pUniformName + "'. Existing uniforms: " + this.mUniformLocations.toString());
    }

    public int getUniformLocationOptional(String pUniformName) {
        Integer location = this.mUniformLocations.get(pUniformName);
        if (location != null) {
            return location;
        }
        return -1;
    }

    public void bind(GLState pGLState, VertexBufferObjectAttributes pVertexBufferObjectAttributes) throws ShaderProgramException {
        if (!this.mCompiled) {
            this.compile(pGLState);
        }
        pGLState.useProgram(this.mProgramID);
        pVertexBufferObjectAttributes.glVertexAttribPointers();
    }

    public void unbind(GLState pGLState) throws ShaderProgramException {
    }

    public void delete(GLState pGLState) {
        if (this.mCompiled) {
            this.mCompiled = false;
            pGLState.deleteProgram(this.mProgramID);
            this.mProgramID = -1;
        }
    }

    protected void compile(GLState pGLState) throws ShaderProgramException {
        String vertexShaderSource = this.mVertexShaderSource.getShaderSource(pGLState);
        int vertexShaderID = ShaderProgram.compileShader(vertexShaderSource, 35633);
        String fragmentShaderSource = this.mFragmentShaderSource.getShaderSource(pGLState);
        int fragmentShaderID = ShaderProgram.compileShader(fragmentShaderSource, 35632);
        this.mProgramID = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgramID, (int)vertexShaderID);
        GLES20.glAttachShader((int)this.mProgramID, (int)fragmentShaderID);
        try {
            this.link(pGLState);
        }
        catch (ShaderProgramLinkException e) {
            throw new ShaderProgramLinkException("VertexShaderSource:\n##########################\n" + vertexShaderSource + "\n##########################" + "\n\nFragmentShaderSource:\n##########################\n" + fragmentShaderSource + "\n##########################", e);
        }
        GLES20.glDeleteShader((int)vertexShaderID);
        GLES20.glDeleteShader((int)fragmentShaderID);
    }

    protected void link(GLState pGLState) throws ShaderProgramLinkException {
        GLES20.glLinkProgram((int)this.mProgramID);
        GLES20.glGetProgramiv((int)this.mProgramID, (int)35714, (int[])HARDWAREID_CONTAINER, (int)0);
        if (HARDWAREID_CONTAINER[0] == 0) {
            throw new ShaderProgramLinkException(GLES20.glGetProgramInfoLog((int)this.mProgramID));
        }
        this.initAttributeLocations();
        this.initUniformLocations();
        this.mCompiled = true;
    }

    private static int compileShader(String pSource, int pType) throws ShaderProgramException {
        int shaderID = GLES20.glCreateShader((int)pType);
        if (shaderID == 0) {
            throw new ShaderProgramException("Could not create Shader of type: '" + pType + '\"');
        }
        GLES20.glShaderSource((int)shaderID, (String)pSource);
        GLES20.glCompileShader((int)shaderID);
        GLES20.glGetShaderiv((int)shaderID, (int)35713, (int[])HARDWAREID_CONTAINER, (int)0);
        if (HARDWAREID_CONTAINER[0] == 0) {
            throw new ShaderProgramCompileException(GLES20.glGetShaderInfoLog((int)shaderID), pSource);
        }
        return shaderID;
    }

    private void initUniformLocations() throws ShaderProgramLinkException {
        this.mUniformLocations.clear();
        ShaderProgram.PARAMETERS_CONTAINER[0] = 0;
        GLES20.glGetProgramiv((int)this.mProgramID, (int)35718, (int[])PARAMETERS_CONTAINER, (int)0);
        int numUniforms = PARAMETERS_CONTAINER[0];
        for (int i = 0; i < numUniforms; ++i) {
            String name;
            int location;
            int length;
            GLES20.glGetActiveUniform((int)this.mProgramID, (int)i, (int)64, (int[])LENGTH_CONTAINER, (int)0, (int[])SIZE_CONTAINER, (int)0, (int[])TYPE_CONTAINER, (int)0, (byte[])NAME_CONTAINER, (int)0);
            if (length == 0) {
                for (length = LENGTH_CONTAINER[0]; length < 64 && NAME_CONTAINER[length] != 0; ++length) {
                }
            }
            if ((location = GLES20.glGetUniformLocation((int)this.mProgramID, (String)(name = new String(NAME_CONTAINER, 0, length)))) == -1) {
                for (length = 0; length < 64 && NAME_CONTAINER[length] != 0; ++length) {
                }
                name = new String(NAME_CONTAINER, 0, length);
                location = GLES20.glGetUniformLocation((int)this.mProgramID, (String)name);
                if (location == -1) {
                    throw new ShaderProgramLinkException("Invalid location for uniform: '" + name + "'.");
                }
            }
            this.mUniformLocations.put(name, location);
        }
    }

    @Deprecated
    private void initAttributeLocations() {
        this.mAttributeLocations.clear();
        ShaderProgram.PARAMETERS_CONTAINER[0] = 0;
        GLES20.glGetProgramiv((int)this.mProgramID, (int)35721, (int[])PARAMETERS_CONTAINER, (int)0);
        int numAttributes = PARAMETERS_CONTAINER[0];
        for (int i = 0; i < numAttributes; ++i) {
            String name;
            int location;
            int length;
            GLES20.glGetActiveAttrib((int)this.mProgramID, (int)i, (int)64, (int[])LENGTH_CONTAINER, (int)0, (int[])SIZE_CONTAINER, (int)0, (int[])TYPE_CONTAINER, (int)0, (byte[])NAME_CONTAINER, (int)0);
            if (length == 0) {
                for (length = LENGTH_CONTAINER[0]; length < 64 && NAME_CONTAINER[length] != 0; ++length) {
                }
            }
            if ((location = GLES20.glGetAttribLocation((int)this.mProgramID, (String)(name = new String(NAME_CONTAINER, 0, length)))) == -1) {
                for (length = 0; length < 64 && NAME_CONTAINER[length] != 0; ++length) {
                }
                name = new String(NAME_CONTAINER, 0, length);
                location = GLES20.glGetAttribLocation((int)this.mProgramID, (String)name);
                if (location == -1) {
                    throw new ShaderProgramLinkException("Invalid location for attribute: '" + name + "'.");
                }
            }
            this.mAttributeLocations.put(name, location);
        }
    }

    public void setUniform(String pUniformName, float[] pGLMatrix) {
        GLES20.glUniformMatrix4fv((int)this.getUniformLocation(pUniformName), (int)1, (boolean)false, (float[])pGLMatrix, (int)0);
    }

    public void setUniformOptional(String pUniformName, float[] pGLMatrix) {
        int location = this.getUniformLocationOptional(pUniformName);
        if (location != -1) {
            GLES20.glUniformMatrix4fv((int)this.getUniformLocationOptional(pUniformName), (int)1, (boolean)false, (float[])pGLMatrix, (int)0);
        }
    }

    public void setUniform(String pUniformName, float pX) {
        GLES20.glUniform1f((int)this.getUniformLocation(pUniformName), (float)pX);
    }

    public void setUniformOptional(String pUniformName, float pX) {
        int location = this.getUniformLocationOptional(pUniformName);
        if (location != -1) {
            GLES20.glUniform1f((int)this.getUniformLocationOptional(pUniformName), (float)pX);
        }
    }

    public void setUniform(String pUniformName, float pX, float pY) {
        GLES20.glUniform2f((int)this.getUniformLocation(pUniformName), (float)pX, (float)pY);
    }

    public void setUniformOptional(String pUniformName, float pX, float pY) {
        int location = this.getUniformLocationOptional(pUniformName);
        if (location != -1) {
            GLES20.glUniform2f((int)this.getUniformLocationOptional(pUniformName), (float)pX, (float)pY);
        }
    }

    public void setUniform(String pUniformName, float pX, float pY, float pZ) {
        GLES20.glUniform3f((int)this.getUniformLocation(pUniformName), (float)pX, (float)pY, (float)pZ);
    }

    public void setUniformOptional(String pUniformName, float pX, float pY, float pZ) {
        int location = this.getUniformLocationOptional(pUniformName);
        if (location != -1) {
            GLES20.glUniform3f((int)this.getUniformLocationOptional(pUniformName), (float)pX, (float)pY, (float)pZ);
        }
    }

    public void setUniform(String pUniformName, float pX, float pY, float pZ, float pW) {
        GLES20.glUniform4f((int)this.getUniformLocation(pUniformName), (float)pX, (float)pY, (float)pZ, (float)pW);
    }

    public void setUniformOptional(String pUniformName, float pX, float pY, float pZ, float pW) {
        int location = this.getUniformLocationOptional(pUniformName);
        if (location != -1) {
            GLES20.glUniform4f((int)this.getUniformLocationOptional(pUniformName), (float)pX, (float)pY, (float)pZ, (float)pW);
        }
    }

    public void setTexture(String pUniformName, int pTexture) {
        GLES20.glUniform1i((int)this.getUniformLocation(pUniformName), (int)pTexture);
    }

    public void setTextureOptional(String pUniformName, int pTexture) {
        int location = this.getUniformLocationOptional(pUniformName);
        if (location != -1) {
            GLES20.glUniform1i((int)location, (int)pTexture);
        }
    }
}

