/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.shader;

import java.util.ArrayList;
import org.andengine.opengl.shader.PositionColorShaderProgram;
import org.andengine.opengl.shader.PositionColorTextureCoordinatesShaderProgram;
import org.andengine.opengl.shader.PositionTextureCoordinatesPositionInterpolationTextureSelectShaderProgram;
import org.andengine.opengl.shader.PositionTextureCoordinatesShaderProgram;
import org.andengine.opengl.shader.PositionTextureCoordinatesTextureSelectShaderProgram;
import org.andengine.opengl.shader.PositionTextureCoordinatesUniformColorShaderProgram;
import org.andengine.opengl.shader.ShaderProgram;
import org.andengine.util.debug.Debug;

public class ShaderProgramManager {
    private final ArrayList<ShaderProgram> mShaderProgramsManaged = new ArrayList();

    public synchronized void onCreate() {
        this.loadShaderProgram(PositionColorTextureCoordinatesShaderProgram.getInstance());
        this.loadShaderProgram(PositionTextureCoordinatesShaderProgram.getInstance());
        this.loadShaderProgram(PositionTextureCoordinatesUniformColorShaderProgram.getInstance());
        this.loadShaderProgram(PositionColorShaderProgram.getInstance());
        this.loadShaderProgram(PositionTextureCoordinatesTextureSelectShaderProgram.getInstance());
        this.loadShaderProgram(PositionTextureCoordinatesPositionInterpolationTextureSelectShaderProgram.getInstance());
    }

    public synchronized void onDestroy() {
        ArrayList<ShaderProgram> managedShaderPrograms = this.mShaderProgramsManaged;
        for (int i = managedShaderPrograms.size() - 1; i >= 0; --i) {
            managedShaderPrograms.get(i).setCompiled(false);
        }
        this.mShaderProgramsManaged.clear();
    }

    public synchronized void loadShaderProgram(ShaderProgram pShaderProgram) {
        if (pShaderProgram == null) {
            throw new IllegalArgumentException("pShaderProgram must not be null!");
        }
        if (pShaderProgram.isCompiled()) {
            Debug.w("Loading an already compiled " + ShaderProgram.class.getSimpleName() + ": '" + pShaderProgram.getClass().getSimpleName() + "'. '" + pShaderProgram.getClass().getSimpleName() + "' will be recompiled.");
            pShaderProgram.setCompiled(false);
        }
        if (this.mShaderProgramsManaged.contains(pShaderProgram)) {
            Debug.w("Loading an already loaded " + ShaderProgram.class.getSimpleName() + ": '" + pShaderProgram.getClass().getSimpleName() + "'.");
        } else {
            this.mShaderProgramsManaged.add(pShaderProgram);
        }
    }

    public void loadShaderPrograms(ShaderProgram ... pShaderPrograms) {
        for (int i = pShaderPrograms.length - 1; i >= 0; --i) {
            this.loadShaderProgram(pShaderPrograms[i]);
        }
    }

    public synchronized void onReload() {
        ArrayList<ShaderProgram> managedShaderPrograms = this.mShaderProgramsManaged;
        for (int i = managedShaderPrograms.size() - 1; i >= 0; --i) {
            managedShaderPrograms.get(i).setCompiled(false);
        }
    }
}

