/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.shader.source;

import org.andengine.opengl.shader.exception.ShaderProgramException;
import org.andengine.opengl.shader.source.IShaderSource;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.util.criteria.IGLCriteria;

public class CriteriaShaderSource
implements IShaderSource {
    private final CriteriaShaderSourceEntry[] mCriteriaShaderSourceEntries;

    public CriteriaShaderSource(CriteriaShaderSourceEntry ... pCriteriaShaderSourceEntries) {
        this.mCriteriaShaderSourceEntries = pCriteriaShaderSourceEntries;
    }

    @Override
    public String getShaderSource(GLState pGLState) {
        for (int i = 0; i < this.mCriteriaShaderSourceEntries.length; ++i) {
            CriteriaShaderSourceEntry criteriaShaderSourceEntry = this.mCriteriaShaderSourceEntries[i];
            if (!criteriaShaderSourceEntry.isMet(pGLState)) continue;
            return criteriaShaderSourceEntry.getShaderSource();
        }
        throw new ShaderProgramException("No " + CriteriaShaderSourceEntry.class.getSimpleName() + " met!");
    }

    public static class CriteriaShaderSourceEntry {
        private final String mShaderSource;
        private final IGLCriteria[] mGLCriterias;

        public CriteriaShaderSourceEntry(String pShaderSource) {
            this(pShaderSource, null);
        }

        public CriteriaShaderSourceEntry(String pShaderSource, IGLCriteria ... pCriterias) {
            this.mGLCriterias = pCriterias;
            this.mShaderSource = pShaderSource;
        }

        public String getShaderSource() {
            return this.mShaderSource;
        }

        public boolean isMet(GLState pGLState) {
            if (this.mGLCriterias != null) {
                for (IGLCriteria gLCriteria : this.mGLCriterias) {
                    if (gLCriteria.isMet(pGLState)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

