/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture;

import java.io.IOException;
import org.andengine.opengl.texture.ITexture;
import org.andengine.opengl.texture.ITextureStateListener;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.util.GLState;

public abstract class Texture
implements ITexture {
    public static final int HARDWARE_TEXTURE_ID_INVALID = -1;
    protected final TextureManager mTextureManager;
    protected final PixelFormat mPixelFormat;
    protected final TextureOptions mTextureOptions;
    protected int mHardwareTextureID = -1;
    protected boolean mUpdateOnHardwareNeeded = false;
    protected ITextureStateListener mTextureStateListener;

    public Texture(TextureManager pTextureManager, PixelFormat pPixelFormat, TextureOptions pTextureOptions, ITextureStateListener pTextureStateListener) throws IllegalArgumentException {
        this.mTextureManager = pTextureManager;
        this.mPixelFormat = pPixelFormat;
        this.mTextureOptions = pTextureOptions;
        this.mTextureStateListener = pTextureStateListener;
    }

    @Override
    public int getHardwareTextureID() {
        return this.mHardwareTextureID;
    }

    @Override
    public boolean isLoadedToHardware() {
        return this.mHardwareTextureID != -1;
    }

    @Override
    public void setNotLoadedToHardware() {
        this.mHardwareTextureID = -1;
    }

    @Override
    public boolean isUpdateOnHardwareNeeded() {
        return this.mUpdateOnHardwareNeeded;
    }

    @Override
    public void setUpdateOnHardwareNeeded(boolean pUpdateOnHardwareNeeded) {
        this.mUpdateOnHardwareNeeded = pUpdateOnHardwareNeeded;
    }

    @Override
    public PixelFormat getPixelFormat() {
        return this.mPixelFormat;
    }

    @Override
    public TextureOptions getTextureOptions() {
        return this.mTextureOptions;
    }

    @Override
    public ITextureStateListener getTextureStateListener() {
        return this.mTextureStateListener;
    }

    @Override
    public void setTextureStateListener(ITextureStateListener pTextureStateListener) {
        this.mTextureStateListener = pTextureStateListener;
    }

    @Override
    public boolean hasTextureStateListener() {
        return this.mTextureStateListener != null;
    }

    protected abstract void writeTextureToHardware(GLState var1) throws IOException;

    @Override
    public void load() {
        this.mTextureManager.loadTexture(this);
    }

    @Override
    public void load(GLState pGLState) throws IOException {
        this.mTextureManager.loadTexture(pGLState, this);
    }

    @Override
    public void unload() {
        this.mTextureManager.unloadTexture(this);
    }

    @Override
    public void unload(GLState pGLState) {
        this.mTextureManager.unloadTexture(pGLState, this);
    }

    @Override
    public void loadToHardware(GLState pGLState) throws IOException {
        this.mHardwareTextureID = pGLState.generateTexture();
        pGLState.bindTexture(this.mHardwareTextureID);
        this.writeTextureToHardware(pGLState);
        this.mTextureOptions.apply();
        this.mUpdateOnHardwareNeeded = false;
        if (this.mTextureStateListener != null) {
            this.mTextureStateListener.onLoadedToHardware(this);
        }
    }

    @Override
    public void unloadFromHardware(GLState pGLState) {
        pGLState.deleteTexture(this.mHardwareTextureID);
        this.mHardwareTextureID = -1;
        if (this.mTextureStateListener != null) {
            this.mTextureStateListener.onUnloadedFromHardware(this);
        }
    }

    @Override
    public void reloadToHardware(GLState pGLState) throws IOException {
        this.unloadFromHardware(pGLState);
        this.loadToHardware(pGLState);
    }

    @Override
    public void bind(GLState pGLState) {
        pGLState.bindTexture(this.mHardwareTextureID);
    }

    @Override
    public void bind(GLState pGLState, int pGLActiveTexture) {
        pGLState.activeTexture(pGLActiveTexture);
        pGLState.bindTexture(this.mHardwareTextureID);
    }
}

