/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture;

import android.content.res.AssetManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.andengine.opengl.texture.ITexture;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.texture.TextureWarmUpVertexBufferObject;
import org.andengine.opengl.texture.bitmap.BitmapTexture;
import org.andengine.opengl.texture.bitmap.BitmapTextureFormat;
import org.andengine.opengl.util.GLState;
import org.andengine.util.adt.io.in.AssetInputStreamOpener;
import org.andengine.util.adt.io.in.IInputStreamOpener;
import org.andengine.util.debug.Debug;

public class TextureManager {
    private final HashSet<ITexture> mTexturesManaged = new HashSet();
    private final HashMap<String, ITexture> mTexturesMapped = new HashMap();
    private final ArrayList<ITexture> mTexturesLoaded = new ArrayList();
    private final ArrayList<ITexture> mTexturesToBeLoaded = new ArrayList();
    private final ArrayList<ITexture> mTexturesToBeUnloaded = new ArrayList();
    private TextureWarmUpVertexBufferObject mTextureWarmUpVertexBufferObject;

    public synchronized void onCreate() {
        this.mTextureWarmUpVertexBufferObject = new TextureWarmUpVertexBufferObject();
    }

    public synchronized void onReload() {
        HashSet<ITexture> managedTextures = this.mTexturesManaged;
        if (!managedTextures.isEmpty()) {
            for (ITexture texture : managedTextures) {
                texture.setNotLoadedToHardware();
            }
        }
        if (!this.mTexturesLoaded.isEmpty()) {
            this.mTexturesToBeLoaded.addAll(this.mTexturesLoaded);
            this.mTexturesLoaded.clear();
        }
        if (!this.mTexturesToBeUnloaded.isEmpty()) {
            this.mTexturesManaged.removeAll(this.mTexturesToBeUnloaded);
            this.mTexturesToBeUnloaded.clear();
        }
        this.mTextureWarmUpVertexBufferObject.setNotLoadedToHardware();
    }

    public synchronized void onDestroy() {
        HashSet<ITexture> managedTextures = this.mTexturesManaged;
        for (ITexture texture : managedTextures) {
            texture.setNotLoadedToHardware();
        }
        this.mTexturesToBeLoaded.clear();
        this.mTexturesLoaded.clear();
        this.mTexturesManaged.clear();
        this.mTexturesMapped.clear();
        this.mTextureWarmUpVertexBufferObject.dispose();
        this.mTextureWarmUpVertexBufferObject = null;
    }

    public synchronized boolean hasMappedTexture(String pID) {
        if (pID == null) {
            throw new IllegalArgumentException("pID must not be null!");
        }
        return this.mTexturesMapped.containsKey(pID);
    }

    public synchronized ITexture getMappedTexture(String pID) {
        if (pID == null) {
            throw new IllegalArgumentException("pID must not be null!");
        }
        return this.mTexturesMapped.get(pID);
    }

    public synchronized void addMappedTexture(String pID, ITexture pTexture) throws IllegalArgumentException {
        if (pID == null) {
            throw new IllegalArgumentException("pID must not be null!");
        }
        if (pTexture == null) {
            throw new IllegalArgumentException("pTexture must not be null!");
        }
        if (this.mTexturesMapped.containsKey(pID)) {
            throw new IllegalArgumentException("Collision for pID: '" + pID + "'.");
        }
        this.mTexturesMapped.put(pID, pTexture);
    }

    public synchronized ITexture removedMappedTexture(String pID) {
        if (pID == null) {
            throw new IllegalArgumentException("pID must not be null!");
        }
        return this.mTexturesMapped.remove(pID);
    }

    public synchronized boolean loadTexture(ITexture pTexture) {
        if (pTexture == null) {
            throw new IllegalArgumentException("pTexture must not be null!");
        }
        if (this.mTexturesManaged.contains(pTexture)) {
            this.mTexturesToBeUnloaded.remove(pTexture);
            return false;
        }
        this.mTexturesManaged.add(pTexture);
        this.mTexturesToBeLoaded.add(pTexture);
        return true;
    }

    public synchronized boolean loadTexture(GLState pGLState, ITexture pTexture) throws IOException {
        if (pTexture == null) {
            throw new IllegalArgumentException("pTexture must not be null!");
        }
        if (!pTexture.isLoadedToHardware()) {
            pTexture.loadToHardware(pGLState);
        } else if (pTexture.isUpdateOnHardwareNeeded()) {
            pTexture.reloadToHardware(pGLState);
        }
        if (this.mTexturesManaged.contains(pTexture)) {
            this.mTexturesToBeUnloaded.remove(pTexture);
            return false;
        }
        this.mTexturesManaged.add(pTexture);
        this.mTexturesLoaded.add(pTexture);
        return true;
    }

    public synchronized boolean unloadTexture(ITexture pTexture) {
        if (pTexture == null) {
            throw new IllegalArgumentException("pTexture must not be null!");
        }
        if (this.mTexturesManaged.contains(pTexture)) {
            if (this.mTexturesLoaded.contains(pTexture)) {
                this.mTexturesToBeUnloaded.add(pTexture);
            } else if (this.mTexturesToBeLoaded.remove(pTexture)) {
                this.mTexturesManaged.remove(pTexture);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean unloadTexture(GLState pGLState, ITexture pTexture) {
        if (pTexture == null) {
            throw new IllegalArgumentException("pTexture must not be null!");
        }
        if (pTexture.isLoadedToHardware()) {
            pTexture.unloadFromHardware(pGLState);
        }
        if (this.mTexturesManaged.contains(pTexture)) {
            this.mTexturesLoaded.remove(pTexture);
            this.mTexturesToBeLoaded.remove(pTexture);
            return true;
        }
        return false;
    }

    public synchronized void updateTextures(GLState pGLState) {
        int texturesToBeUnloadedCount;
        HashSet<ITexture> texturesManaged = this.mTexturesManaged;
        ArrayList<ITexture> texturesLoaded = this.mTexturesLoaded;
        ArrayList<ITexture> texturesToBeLoaded = this.mTexturesToBeLoaded;
        ArrayList<ITexture> texturesToBeUnloaded = this.mTexturesToBeUnloaded;
        for (int i = texturesLoaded.size() - 1; i >= 0; --i) {
            ITexture textureToBeReloaded = texturesLoaded.get(i);
            if (!textureToBeReloaded.isUpdateOnHardwareNeeded()) continue;
            try {
                textureToBeReloaded.reloadToHardware(pGLState);
                continue;
            }
            catch (IOException e) {
                Debug.e(e);
            }
        }
        int texturesToBeLoadedCount = texturesToBeLoaded.size();
        if (texturesToBeLoadedCount > 0) {
            for (int i = texturesToBeLoadedCount - 1; i >= 0; --i) {
                ITexture textureToBeLoaded = texturesToBeLoaded.remove(i);
                if (!textureToBeLoaded.isLoadedToHardware()) {
                    try {
                        textureToBeLoaded.loadToHardware(pGLState);
                        this.mTextureWarmUpVertexBufferObject.warmup(pGLState, textureToBeLoaded);
                    }
                    catch (IOException e) {
                        Debug.e(e);
                    }
                }
                texturesLoaded.add(textureToBeLoaded);
            }
        }
        if ((texturesToBeUnloadedCount = texturesToBeUnloaded.size()) > 0) {
            for (int i = texturesToBeUnloadedCount - 1; i >= 0; --i) {
                ITexture textureToBeUnloaded = texturesToBeUnloaded.remove(i);
                if (textureToBeUnloaded.isLoadedToHardware()) {
                    textureToBeUnloaded.unloadFromHardware(pGLState);
                }
                texturesLoaded.remove(textureToBeUnloaded);
                texturesManaged.remove(textureToBeUnloaded);
            }
        }
        if (texturesToBeLoadedCount > 0 || texturesToBeUnloadedCount > 0) {
            System.gc();
        }
    }

    public synchronized ITexture getTexture(String pID, AssetManager pAssetManager, String pAssetPath) throws IOException {
        return this.getTexture(pID, pAssetManager, pAssetPath, TextureOptions.DEFAULT);
    }

    public synchronized ITexture getTexture(String pID, AssetManager pAssetManager, String pAssetPath, TextureOptions pTextureOptions) throws IOException {
        if (this.hasMappedTexture(pID)) {
            return this.getMappedTexture(pID);
        }
        BitmapTexture texture = new BitmapTexture(this, (IInputStreamOpener)new AssetInputStreamOpener(pAssetManager, pAssetPath), pTextureOptions);
        this.loadTexture(texture);
        this.addMappedTexture(pID, texture);
        return texture;
    }

    public synchronized ITexture getTexture(String pID, IInputStreamOpener pInputStreamOpener) throws IOException {
        return this.getTexture(pID, pInputStreamOpener, TextureOptions.DEFAULT);
    }

    public synchronized ITexture getTexture(String pID, IInputStreamOpener pInputStreamOpener, TextureOptions pTextureOptions) throws IOException {
        return this.getTexture(pID, pInputStreamOpener, BitmapTextureFormat.RGBA_8888, pTextureOptions);
    }

    public synchronized ITexture getTexture(String pID, IInputStreamOpener pInputStreamOpener, BitmapTextureFormat pBitmapTextureFormat, TextureOptions pTextureOptions) throws IOException {
        return this.getTexture(pID, pInputStreamOpener, pBitmapTextureFormat, pTextureOptions, true);
    }

    public synchronized ITexture getTexture(String pID, IInputStreamOpener pInputStreamOpener, BitmapTextureFormat pBitmapTextureFormat, TextureOptions pTextureOptions, boolean pLoadToHardware) throws IOException {
        if (this.hasMappedTexture(pID)) {
            return this.getMappedTexture(pID);
        }
        BitmapTexture texture = new BitmapTexture(this, pInputStreamOpener, pBitmapTextureFormat, pTextureOptions);
        if (pLoadToHardware) {
            this.loadTexture(texture);
        }
        this.addMappedTexture(pID, texture);
        return texture;
    }
}

