/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas;

import java.util.ArrayList;
import org.andengine.opengl.texture.ITextureStateListener;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.texture.Texture;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.texture.atlas.ITextureAtlas;
import org.andengine.opengl.texture.atlas.source.ITextureAtlasSource;

public abstract class TextureAtlas<T extends ITextureAtlasSource>
extends Texture
implements ITextureAtlas<T> {
    protected final int mWidth;
    protected final int mHeight;
    protected final ArrayList<T> mTextureAtlasSources = new ArrayList();

    public TextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, PixelFormat pPixelFormat, TextureOptions pTextureOptions, ITextureAtlas.ITextureAtlasStateListener<T> pTextureAtlasStateListener) {
        super(pTextureManager, pPixelFormat, pTextureOptions, pTextureAtlasStateListener);
        this.mWidth = pWidth;
        this.mHeight = pHeight;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    @Deprecated
    public boolean hasTextureStateListener() {
        return super.hasTextureStateListener();
    }

    @Override
    public boolean hasTextureAtlasStateListener() {
        return super.hasTextureStateListener();
    }

    @Override
    @Deprecated
    public ITextureAtlas.ITextureAtlasStateListener<T> getTextureStateListener() {
        return this.getTextureAtlasStateListener();
    }

    @Override
    public ITextureAtlas.ITextureAtlasStateListener<T> getTextureAtlasStateListener() {
        return (ITextureAtlas.ITextureAtlasStateListener)super.getTextureStateListener();
    }

    @Override
    @Deprecated
    public void setTextureStateListener(ITextureStateListener pTextureStateListener) {
        super.setTextureStateListener(pTextureStateListener);
    }

    @Override
    public void setTextureAtlasStateListener(ITextureAtlas.ITextureAtlasStateListener<T> pTextureAtlasStateListener) {
        super.setTextureStateListener(pTextureAtlasStateListener);
    }

    @Override
    public void addTextureAtlasSource(T pTextureAtlasSource, int pTextureX, int pTextureY) throws IllegalArgumentException {
        this.checkTextureAtlasSourcePosition(pTextureAtlasSource, pTextureX, pTextureY);
        pTextureAtlasSource.setTextureX(pTextureX);
        pTextureAtlasSource.setTextureY(pTextureY);
        this.mTextureAtlasSources.add(pTextureAtlasSource);
        this.mUpdateOnHardwareNeeded = true;
    }

    @Override
    public void addTextureAtlasSource(T pTextureAtlasSource, int pTextureX, int pTextureY, int pTextureAtlasSourcePadding) throws IllegalArgumentException {
        this.addTextureAtlasSource(pTextureAtlasSource, pTextureX, pTextureY);
        if (pTextureAtlasSourcePadding > 0) {
            if (pTextureX >= pTextureAtlasSourcePadding) {
                this.addEmptyTextureAtlasSource(pTextureX - pTextureAtlasSourcePadding, pTextureY, pTextureAtlasSourcePadding, pTextureAtlasSource.getTextureHeight());
            }
            if (pTextureY >= pTextureAtlasSourcePadding) {
                this.addEmptyTextureAtlasSource(pTextureX, pTextureY - pTextureAtlasSourcePadding, pTextureAtlasSource.getTextureWidth(), pTextureAtlasSourcePadding);
            }
            if (pTextureX + pTextureAtlasSource.getTextureWidth() - 1 + pTextureAtlasSourcePadding <= this.getWidth()) {
                this.addEmptyTextureAtlasSource(pTextureX + pTextureAtlasSource.getTextureWidth(), pTextureY, pTextureAtlasSourcePadding, pTextureAtlasSource.getTextureHeight());
            }
            if (pTextureY + pTextureAtlasSource.getTextureHeight() - 1 + pTextureAtlasSourcePadding <= this.getHeight()) {
                this.addEmptyTextureAtlasSource(pTextureX, pTextureY + pTextureAtlasSource.getTextureHeight(), pTextureAtlasSource.getTextureWidth(), pTextureAtlasSourcePadding);
            }
        }
    }

    @Override
    public void removeTextureAtlasSource(T pTextureAtlasSource, int pTextureX, int pTextureY) {
        ArrayList<T> textureSources = this.mTextureAtlasSources;
        for (int i = textureSources.size() - 1; i >= 0; --i) {
            ITextureAtlasSource textureSource = (ITextureAtlasSource)textureSources.get(i);
            if (textureSource != pTextureAtlasSource || textureSource.getTextureX() != pTextureX || textureSource.getTextureY() != pTextureY) continue;
            textureSources.remove(i);
            this.mUpdateOnHardwareNeeded = true;
            return;
        }
    }

    @Override
    public void clearTextureAtlasSources() {
        this.mTextureAtlasSources.clear();
        this.mUpdateOnHardwareNeeded = true;
    }

    private void checkTextureAtlasSourcePosition(T pTextureAtlasSource, int pTextureX, int pTextureY) throws IllegalArgumentException {
        if (pTextureX < 0) {
            throw new IllegalArgumentException("Illegal negative pTextureX supplied: '" + pTextureX + "'");
        }
        if (pTextureY < 0) {
            throw new IllegalArgumentException("Illegal negative pTextureY supplied: '" + pTextureY + "'");
        }
        if (pTextureX + pTextureAtlasSource.getTextureWidth() > this.getWidth() || pTextureY + pTextureAtlasSource.getTextureHeight() > this.getHeight()) {
            throw new IllegalArgumentException("Supplied pTextureAtlasSource must not exceed bounds of Texture.");
        }
    }
}

