/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.bitmap;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.util.ArrayList;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.texture.atlas.ITextureAtlas;
import org.andengine.opengl.texture.atlas.TextureAtlas;
import org.andengine.opengl.texture.atlas.bitmap.source.EmptyBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.bitmap.BitmapTextureFormat;
import org.andengine.opengl.util.GLState;
import org.andengine.util.exception.NullBitmapException;
import org.andengine.util.math.MathUtils;

public class BitmapTextureAtlas
extends TextureAtlas<IBitmapTextureAtlasSource> {
    private final BitmapTextureFormat mBitmapTextureFormat;

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight) {
        this(pTextureManager, pWidth, pHeight, BitmapTextureFormat.RGBA_8888);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, BitmapTextureFormat pBitmapTextureFormat) {
        this(pTextureManager, pWidth, pHeight, pBitmapTextureFormat, TextureOptions.DEFAULT, null);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, ITextureAtlas.ITextureAtlasStateListener<IBitmapTextureAtlasSource> pTextureAtlasStateListener) {
        this(pTextureManager, pWidth, pHeight, BitmapTextureFormat.RGBA_8888, TextureOptions.DEFAULT, pTextureAtlasStateListener);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, BitmapTextureFormat pBitmapTextureFormat, ITextureAtlas.ITextureAtlasStateListener<IBitmapTextureAtlasSource> pTextureAtlasStateListener) {
        this(pTextureManager, pWidth, pHeight, pBitmapTextureFormat, TextureOptions.DEFAULT, pTextureAtlasStateListener);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, TextureOptions pTextureOptions) throws IllegalArgumentException {
        this(pTextureManager, pWidth, pHeight, BitmapTextureFormat.RGBA_8888, pTextureOptions, null);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, BitmapTextureFormat pBitmapTextureFormat, TextureOptions pTextureOptions) throws IllegalArgumentException {
        this(pTextureManager, pWidth, pHeight, pBitmapTextureFormat, pTextureOptions, null);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, TextureOptions pTextureOptions, ITextureAtlas.ITextureAtlasStateListener<IBitmapTextureAtlasSource> pTextureAtlasStateListener) throws IllegalArgumentException {
        this(pTextureManager, pWidth, pHeight, BitmapTextureFormat.RGBA_8888, pTextureOptions, pTextureAtlasStateListener);
    }

    public BitmapTextureAtlas(TextureManager pTextureManager, int pWidth, int pHeight, BitmapTextureFormat pBitmapTextureFormat, TextureOptions pTextureOptions, ITextureAtlas.ITextureAtlasStateListener<IBitmapTextureAtlasSource> pTextureAtlasStateListener) throws IllegalArgumentException {
        super(pTextureManager, pWidth, pHeight, pBitmapTextureFormat.getPixelFormat(), pTextureOptions, pTextureAtlasStateListener);
        this.mBitmapTextureFormat = pBitmapTextureFormat;
    }

    public BitmapTextureFormat getBitmapTextureFormat() {
        return this.mBitmapTextureFormat;
    }

    @Override
    public void addEmptyTextureAtlasSource(int pTextureX, int pTextureY, int pWidth, int pHeight) {
        this.addTextureAtlasSource(new EmptyBitmapTextureAtlasSource(pWidth, pHeight), pTextureX, pTextureY);
    }

    @Override
    protected void writeTextureToHardware(GLState pGLState) {
        PixelFormat pixelFormat = this.mBitmapTextureFormat.getPixelFormat();
        int glInternalFormat = pixelFormat.getGLInternalFormat();
        int glFormat = pixelFormat.getGLFormat();
        int glType = pixelFormat.getGLType();
        GLES20.glTexImage2D((int)3553, (int)0, (int)glInternalFormat, (int)this.mWidth, (int)this.mHeight, (int)0, (int)glFormat, (int)glType, null);
        boolean preMultipyAlpha = this.mTextureOptions.mPreMultiplyAlpha;
        Bitmap.Config bitmapConfig = preMultipyAlpha ? this.mBitmapTextureFormat.getBitmapConfig() : Bitmap.Config.ARGB_8888;
        ArrayList textureSources = this.mTextureAtlasSources;
        int textureSourceCount = textureSources.size();
        ITextureAtlas.ITextureAtlasStateListener<IBitmapTextureAtlasSource> textureStateListener = this.getTextureAtlasStateListener();
        for (int i = 0; i < textureSourceCount; ++i) {
            IBitmapTextureAtlasSource bitmapTextureAtlasSource = (IBitmapTextureAtlasSource)textureSources.get(i);
            try {
                boolean useDefaultAlignment;
                Bitmap bitmap = bitmapTextureAtlasSource.onLoadBitmap(bitmapConfig);
                if (bitmap == null) {
                    throw new NullBitmapException("Caused by: " + bitmapTextureAtlasSource.getClass().toString() + " --> " + bitmapTextureAtlasSource.toString() + " returned a null Bitmap.");
                }
                boolean bl = useDefaultAlignment = MathUtils.isPowerOfTwo(bitmap.getWidth()) && MathUtils.isPowerOfTwo(bitmap.getHeight()) && pixelFormat == PixelFormat.RGBA_8888;
                if (!useDefaultAlignment) {
                    GLES20.glPixelStorei((int)3317, (int)1);
                }
                if (preMultipyAlpha) {
                    GLUtils.texSubImage2D((int)3553, (int)0, (int)bitmapTextureAtlasSource.getTextureX(), (int)bitmapTextureAtlasSource.getTextureY(), (Bitmap)bitmap, (int)glFormat, (int)glType);
                } else {
                    pGLState.glTexSubImage2D(3553, 0, bitmapTextureAtlasSource.getTextureX(), bitmapTextureAtlasSource.getTextureY(), bitmap, this.mPixelFormat);
                }
                if (!useDefaultAlignment) {
                    GLES20.glPixelStorei((int)3317, (int)4);
                }
                bitmap.recycle();
                if (textureStateListener == null) continue;
                textureStateListener.onTextureAtlasSourceLoaded(this, bitmapTextureAtlasSource);
                continue;
            }
            catch (NullBitmapException e) {
                if (textureStateListener != null) {
                    textureStateListener.onTextureAtlasSourceLoadExeption(this, bitmapTextureAtlasSource, e);
                    continue;
                }
                throw e;
            }
        }
    }
}

