/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.bitmap.source;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.IOException;
import java.io.InputStream;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.source.BaseTextureAtlasSource;
import org.andengine.util.StreamUtils;
import org.andengine.util.debug.Debug;

public class AssetBitmapTextureAtlasSource
extends BaseTextureAtlasSource
implements IBitmapTextureAtlasSource {
    private final AssetManager mAssetManager;
    private final String mAssetPath;

    public static AssetBitmapTextureAtlasSource create(AssetManager pAssetManager, String pAssetPath) {
        return AssetBitmapTextureAtlasSource.create(pAssetManager, pAssetPath, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssetBitmapTextureAtlasSource create(AssetManager pAssetManager, String pAssetPath, int pTextureX, int pTextureY) {
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inJustDecodeBounds = true;
        InputStream in = null;
        try {
            in = pAssetManager.open(pAssetPath);
            BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)decodeOptions);
        }
        catch (IOException e) {
            Debug.e("Failed loading Bitmap in AssetBitmapTextureAtlasSource. AssetPath: " + pAssetPath, e);
        }
        finally {
            StreamUtils.close(in);
        }
        return new AssetBitmapTextureAtlasSource(pAssetManager, pAssetPath, pTextureX, pTextureY, decodeOptions.outWidth, decodeOptions.outHeight);
    }

    AssetBitmapTextureAtlasSource(AssetManager pAssetManager, String pAssetPath, int pTextureX, int pTextureY, int pTextureWidth, int pTextureHeight) {
        super(pTextureX, pTextureY, pTextureWidth, pTextureHeight);
        this.mAssetManager = pAssetManager;
        this.mAssetPath = pAssetPath;
    }

    @Override
    public AssetBitmapTextureAtlasSource deepCopy() {
        return new AssetBitmapTextureAtlasSource(this.mAssetManager, this.mAssetPath, this.mTextureX, this.mTextureY, this.mTextureWidth, this.mTextureHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap onLoadBitmap(Bitmap.Config pBitmapConfig) {
        Bitmap bitmap;
        InputStream in = null;
        try {
            BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
            decodeOptions.inPreferredConfig = pBitmapConfig;
            in = this.mAssetManager.open(this.mAssetPath);
            bitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)decodeOptions);
        }
        catch (IOException e) {
            Bitmap bitmap2;
            try {
                Debug.e("Failed loading Bitmap in " + this.getClass().getSimpleName() + ". AssetPath: " + this.mAssetPath, e);
                bitmap2 = null;
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
            StreamUtils.close(in);
            return bitmap2;
        }
        StreamUtils.close(in);
        return bitmap;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.mAssetPath + ")";
    }
}

