/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.bitmap.source;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.source.BaseTextureAtlasSource;
import org.andengine.util.FileUtils;
import org.andengine.util.StreamUtils;
import org.andengine.util.debug.Debug;

public class FileBitmapTextureAtlasSource
extends BaseTextureAtlasSource
implements IBitmapTextureAtlasSource {
    private final File mFile;

    public static FileBitmapTextureAtlasSource create(File pFile) {
        return FileBitmapTextureAtlasSource.create(pFile, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileBitmapTextureAtlasSource create(File pFile, int pTextureX, int pTextureY) {
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inJustDecodeBounds = true;
        FileInputStream in = null;
        try {
            in = new FileInputStream(pFile);
            BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)decodeOptions);
        }
        catch (IOException e) {
            try {
                Debug.e("Failed loading Bitmap in " + FileBitmapTextureAtlasSource.class.getSimpleName() + ". File: " + pFile, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
            StreamUtils.close(in);
        }
        StreamUtils.close(in);
        return new FileBitmapTextureAtlasSource(pFile, pTextureX, pTextureY, decodeOptions.outWidth, decodeOptions.outHeight);
    }

    public static FileBitmapTextureAtlasSource createFromInternalStorage(Context pContext, String pFilePath, int pTextureX, int pTextureY) {
        return FileBitmapTextureAtlasSource.create(new File(FileUtils.getAbsolutePathOnInternalStorage(pContext, pFilePath)), pTextureX, pTextureY);
    }

    public static FileBitmapTextureAtlasSource createFromExternalStorage(Context pContext, String pFilePath, int pTextureX, int pTextureY) {
        return FileBitmapTextureAtlasSource.create(new File(FileUtils.getAbsolutePathOnExternalStorage(pContext, pFilePath)), pTextureX, pTextureY);
    }

    FileBitmapTextureAtlasSource(File pFile, int pTextureX, int pTextureY, int pTextureWidth, int pTextureHeight) {
        super(pTextureX, pTextureY, pTextureWidth, pTextureHeight);
        this.mFile = pFile;
    }

    @Override
    public FileBitmapTextureAtlasSource deepCopy() {
        return new FileBitmapTextureAtlasSource(this.mFile, this.mTextureX, this.mTextureY, this.mTextureWidth, this.mTextureHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap onLoadBitmap(Bitmap.Config pBitmapConfig) {
        Bitmap bitmap;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inPreferredConfig = pBitmapConfig;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.mFile);
            bitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)decodeOptions);
        }
        catch (IOException e) {
            Bitmap bitmap2;
            try {
                Debug.e("Failed loading Bitmap in " + this.getClass().getSimpleName() + ". File: " + this.mFile, e);
                bitmap2 = null;
            }
            catch (Throwable throwable) {
                StreamUtils.close(in);
                throw throwable;
            }
            StreamUtils.close(in);
            return bitmap2;
        }
        StreamUtils.close(in);
        return bitmap;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.mFile + ")";
    }
}

