/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.bitmap.source;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.source.BaseTextureAtlasSource;

public class ResourceBitmapTextureAtlasSource
extends BaseTextureAtlasSource
implements IBitmapTextureAtlasSource {
    private final Resources mResources;
    private final int mDrawableResourceID;

    public static ResourceBitmapTextureAtlasSource create(Resources pResources, int pDrawableResourceID) {
        return ResourceBitmapTextureAtlasSource.create(pResources, pDrawableResourceID, 0, 0);
    }

    public static ResourceBitmapTextureAtlasSource create(Resources pResources, int pDrawableResourceID, int pTextureX, int pTextureY) {
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)pResources, (int)pDrawableResourceID, (BitmapFactory.Options)decodeOptions);
        return new ResourceBitmapTextureAtlasSource(pResources, pDrawableResourceID, pTextureX, pTextureY, decodeOptions.outWidth, decodeOptions.outHeight);
    }

    public ResourceBitmapTextureAtlasSource(Resources pResources, int pDrawableResourceID, int pTextureX, int pTextureY, int pTextureWidth, int pTextureHeight) {
        super(pTextureX, pTextureY, pTextureWidth, pTextureHeight);
        this.mResources = pResources;
        this.mDrawableResourceID = pDrawableResourceID;
    }

    @Override
    public ResourceBitmapTextureAtlasSource deepCopy() {
        return new ResourceBitmapTextureAtlasSource(this.mResources, this.mDrawableResourceID, this.mTextureX, this.mTextureY, this.mTextureWidth, this.mTextureHeight);
    }

    @Override
    public Bitmap onLoadBitmap(Bitmap.Config pBitmapConfig) {
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inPreferredConfig = pBitmapConfig;
        return BitmapFactory.decodeResource((Resources)this.mResources, (int)this.mDrawableResourceID, (BitmapFactory.Options)decodeOptions);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.mDrawableResourceID + ")";
    }
}

