/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.bitmap.source.decorator;

import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.bitmap.source.decorator.BaseBitmapTextureAtlasSourceDecorator;
import org.andengine.opengl.texture.atlas.bitmap.source.decorator.BaseShapeBitmapTextureAtlasSourceDecorator;
import org.andengine.opengl.texture.atlas.bitmap.source.decorator.shape.IBitmapTextureAtlasSourceDecoratorShape;

public class LinearGradientFillBitmapTextureAtlasSourceDecorator
extends BaseShapeBitmapTextureAtlasSourceDecorator {
    protected final LinearGradientDirection mLinearGradientDirection;
    protected final int[] mColors;
    protected final float[] mPositions;

    public LinearGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int pFromColor, int pToColor, LinearGradientDirection pLinearGradientDirection) {
        this(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, pFromColor, pToColor, pLinearGradientDirection, null);
    }

    public LinearGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int pFromColor, int pToColor, LinearGradientDirection pLinearGradientDirection, BaseBitmapTextureAtlasSourceDecorator.TextureAtlasSourceDecoratorOptions pTextureAtlasSourceDecoratorOptions) {
        this(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, new int[]{pFromColor, pToColor}, null, pLinearGradientDirection, pTextureAtlasSourceDecoratorOptions);
    }

    public LinearGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int[] pColors, float[] pPositions, LinearGradientDirection pLinearGradientDirection) {
        this(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, pColors, pPositions, pLinearGradientDirection, null);
    }

    public LinearGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int[] pColors, float[] pPositions, LinearGradientDirection pLinearGradientDirection, BaseBitmapTextureAtlasSourceDecorator.TextureAtlasSourceDecoratorOptions pTextureAtlasSourceDecoratorOptions) {
        super(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, pTextureAtlasSourceDecoratorOptions);
        this.mColors = pColors;
        this.mPositions = pPositions;
        this.mLinearGradientDirection = pLinearGradientDirection;
        this.mPaint.setStyle(Paint.Style.FILL);
        int right = pBitmapTextureAtlasSource.getTextureWidth() - 1;
        int bottom = pBitmapTextureAtlasSource.getTextureHeight() - 1;
        float fromX = pLinearGradientDirection.getFromX(right);
        float fromY = pLinearGradientDirection.getFromY(bottom);
        float toX = pLinearGradientDirection.getToX(right);
        float toY = pLinearGradientDirection.getToY(bottom);
        this.mPaint.setShader((Shader)new LinearGradient(fromX, fromY, toX, toY, pColors, pPositions, Shader.TileMode.CLAMP));
    }

    @Override
    public LinearGradientFillBitmapTextureAtlasSourceDecorator deepCopy() {
        return new LinearGradientFillBitmapTextureAtlasSourceDecorator(this.mBitmapTextureAtlasSource, this.mBitmapTextureAtlasSourceDecoratorShape, this.mColors, this.mPositions, this.mLinearGradientDirection, this.mTextureAtlasSourceDecoratorOptions);
    }

    public static enum LinearGradientDirection {
        LEFT_TO_RIGHT(1, 0, 0, 0),
        RIGHT_TO_LEFT(0, 0, 1, 0),
        BOTTOM_TO_TOP(0, 1, 0, 0),
        TOP_TO_BOTTOM(0, 0, 0, 1),
        TOPLEFT_TO_BOTTOMRIGHT(0, 0, 1, 1),
        BOTTOMRIGHT_TO_TOPLEFT(1, 1, 0, 0),
        TOPRIGHT_TO_BOTTOMLEFT(1, 0, 0, 1),
        BOTTOMLEFT_TO_TOPRIGHT(0, 1, 1, 0);

        private final int mFromX;
        private final int mFromY;
        private final int mToX;
        private final int mToY;

        private LinearGradientDirection(int pFromX, int pFromY, int pToX, int pToY) {
            this.mFromX = pFromX;
            this.mFromY = pFromY;
            this.mToX = pToX;
            this.mToY = pToY;
        }

        final int getFromX(int pRight) {
            return this.mFromX * pRight;
        }

        final int getFromY(int pBottom) {
            return this.mFromY * pBottom;
        }

        final int getToX(int pRight) {
            return this.mToX * pRight;
        }

        final int getToY(int pBottom) {
            return this.mToY * pBottom;
        }
    }
}

