/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.bitmap.source.decorator;

import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import org.andengine.opengl.texture.atlas.bitmap.source.IBitmapTextureAtlasSource;
import org.andengine.opengl.texture.atlas.bitmap.source.decorator.BaseBitmapTextureAtlasSourceDecorator;
import org.andengine.opengl.texture.atlas.bitmap.source.decorator.BaseShapeBitmapTextureAtlasSourceDecorator;
import org.andengine.opengl.texture.atlas.bitmap.source.decorator.shape.IBitmapTextureAtlasSourceDecoratorShape;
import org.andengine.util.adt.array.ArrayUtils;

public class RadialGradientFillBitmapTextureAtlasSourceDecorator
extends BaseShapeBitmapTextureAtlasSourceDecorator {
    private static final float[] POSITIONS_DEFAULT = new float[]{0.0f, 1.0f};
    protected final RadialGradientDirection mRadialGradientDirection;
    protected final int[] mColors;
    protected final float[] mPositions;

    public RadialGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int pFromColor, int pToColor, RadialGradientDirection pRadialGradientDirection) {
        this(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, pFromColor, pToColor, pRadialGradientDirection, null);
    }

    public RadialGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int pFromColor, int pToColor, RadialGradientDirection pRadialGradientDirection, BaseBitmapTextureAtlasSourceDecorator.TextureAtlasSourceDecoratorOptions pTextureAtlasSourceDecoratorOptions) {
        this(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, new int[]{pFromColor, pToColor}, POSITIONS_DEFAULT, pRadialGradientDirection, pTextureAtlasSourceDecoratorOptions);
    }

    public RadialGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int[] pColors, float[] pPositions, RadialGradientDirection pRadialGradientDirection) {
        this(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, pColors, pPositions, pRadialGradientDirection, null);
    }

    public RadialGradientFillBitmapTextureAtlasSourceDecorator(IBitmapTextureAtlasSource pBitmapTextureAtlasSource, IBitmapTextureAtlasSourceDecoratorShape pBitmapTextureAtlasSourceDecoratorShape, int[] pColors, float[] pPositions, RadialGradientDirection pRadialGradientDirection, BaseBitmapTextureAtlasSourceDecorator.TextureAtlasSourceDecoratorOptions pTextureAtlasSourceDecoratorOptions) {
        super(pBitmapTextureAtlasSource, pBitmapTextureAtlasSourceDecoratorShape, pTextureAtlasSourceDecoratorOptions);
        this.mColors = pColors;
        this.mPositions = pPositions;
        this.mRadialGradientDirection = pRadialGradientDirection;
        this.mPaint.setStyle(Paint.Style.FILL);
        int width = pBitmapTextureAtlasSource.getTextureWidth();
        int height = pBitmapTextureAtlasSource.getTextureHeight();
        float centerX = (float)width * 0.5f;
        float centerY = (float)height * 0.5f;
        float radius = Math.max(centerX, centerY);
        switch (pRadialGradientDirection) {
            case INSIDE_OUT: {
                this.mPaint.setShader((Shader)new RadialGradient(centerX, centerY, radius, pColors, pPositions, Shader.TileMode.CLAMP));
                break;
            }
            case OUTSIDE_IN: {
                ArrayUtils.reverse(pColors);
                this.mPaint.setShader((Shader)new RadialGradient(centerX, centerY, radius, pColors, pPositions, Shader.TileMode.CLAMP));
            }
        }
    }

    @Override
    public RadialGradientFillBitmapTextureAtlasSourceDecorator deepCopy() {
        return new RadialGradientFillBitmapTextureAtlasSourceDecorator(this.mBitmapTextureAtlasSource, this.mBitmapTextureAtlasSourceDecoratorShape, this.mColors, this.mPositions, this.mRadialGradientDirection, this.mTextureAtlasSourceDecoratorOptions);
    }

    public static enum RadialGradientDirection {
        INSIDE_OUT,
        OUTSIDE_IN;

    }
}

