/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.atlas.buildable.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.andengine.opengl.texture.atlas.ITextureAtlas;
import org.andengine.opengl.texture.atlas.buildable.BuildableTextureAtlas;
import org.andengine.opengl.texture.atlas.buildable.builder.ITextureAtlasBuilder;
import org.andengine.opengl.texture.atlas.source.ITextureAtlasSource;

public class BlackPawnTextureAtlasBuilder<T extends ITextureAtlasSource, A extends ITextureAtlas<T>>
implements ITextureAtlasBuilder<T, A> {
    private static final Comparator<BuildableTextureAtlas.TextureAtlasSourceWithWithLocationCallback<?>> TEXTURESOURCE_COMPARATOR = new Comparator<BuildableTextureAtlas.TextureAtlasSourceWithWithLocationCallback<?>>(){

        @Override
        public int compare(BuildableTextureAtlas.TextureAtlasSourceWithWithLocationCallback<?> pTextureAtlasSourceWithWithLocationCallbackA, BuildableTextureAtlas.TextureAtlasSourceWithWithLocationCallback<?> pTextureAtlasSourceWithWithLocationCallbackB) {
            int deltaWidth = pTextureAtlasSourceWithWithLocationCallbackB.getTextureAtlasSource().getTextureWidth() - pTextureAtlasSourceWithWithLocationCallbackA.getTextureAtlasSource().getTextureWidth();
            if (deltaWidth != 0) {
                return deltaWidth;
            }
            return pTextureAtlasSourceWithWithLocationCallbackB.getTextureAtlasSource().getTextureHeight() - pTextureAtlasSourceWithWithLocationCallbackA.getTextureAtlasSource().getTextureHeight();
        }
    };
    private final int mTextureAtlasBorderSpacing;
    private final int mTextureAtlasSourceSpacing;
    private final int mTextureAtlasSourcePadding;

    public BlackPawnTextureAtlasBuilder(int pTextureAtlasBorderSpacing, int pTextureAtlasSourceSpacing, int pTextureAtlasSourcePadding) {
        this.mTextureAtlasBorderSpacing = pTextureAtlasBorderSpacing;
        this.mTextureAtlasSourceSpacing = pTextureAtlasSourceSpacing;
        this.mTextureAtlasSourcePadding = pTextureAtlasSourcePadding;
    }

    @Override
    public void build(A pTextureAtlas, ArrayList<BuildableTextureAtlas.TextureAtlasSourceWithWithLocationCallback<T>> pTextureAtlasSourcesWithLocationCallback) throws ITextureAtlasBuilder.TextureAtlasBuilderException {
        Collections.sort(pTextureAtlasSourcesWithLocationCallback, TEXTURESOURCE_COMPARATOR);
        boolean rootX = false;
        boolean rootY = false;
        int rootWidth = pTextureAtlas.getWidth() - 2 * this.mTextureAtlasBorderSpacing;
        int rootHeight = pTextureAtlas.getHeight() - 2 * this.mTextureAtlasBorderSpacing;
        Node root = new Node(new Rect(0, 0, rootWidth, rootHeight));
        int textureSourceCount = pTextureAtlasSourcesWithLocationCallback.size();
        for (int i = 0; i < textureSourceCount; ++i) {
            BuildableTextureAtlas.TextureAtlasSourceWithWithLocationCallback<T> textureSourceWithLocationCallback = pTextureAtlasSourcesWithLocationCallback.get(i);
            T textureAtlasSource = textureSourceWithLocationCallback.getTextureAtlasSource();
            Node inserted = root.insert((ITextureAtlasSource)textureAtlasSource, rootWidth, rootHeight, this.mTextureAtlasSourceSpacing, this.mTextureAtlasSourcePadding);
            if (inserted == null) {
                throw new ITextureAtlasBuilder.TextureAtlasBuilderException("Could not build: '" + textureAtlasSource.toString() + "' into: '" + pTextureAtlas.getClass().getSimpleName() + "'.");
            }
            int textureAtlasSourceLeft = inserted.mRect.mLeft + this.mTextureAtlasBorderSpacing + this.mTextureAtlasSourcePadding;
            int textureAtlasSourceTop = inserted.mRect.mTop + this.mTextureAtlasBorderSpacing + this.mTextureAtlasSourcePadding;
            if (this.mTextureAtlasSourcePadding == 0) {
                pTextureAtlas.addTextureAtlasSource(textureAtlasSource, textureAtlasSourceLeft, textureAtlasSourceTop);
            } else {
                pTextureAtlas.addTextureAtlasSource(textureAtlasSource, textureAtlasSourceLeft, textureAtlasSourceTop, this.mTextureAtlasSourcePadding);
            }
            textureSourceWithLocationCallback.getCallback().onCallback(textureAtlasSource);
        }
    }

    protected static class Node {
        private Node mChildA;
        private Node mChildB;
        private final Rect mRect;
        private ITextureAtlasSource mTextureAtlasSource;

        public Node(int pLeft, int pTop, int pWidth, int pHeight) {
            this(new Rect(pLeft, pTop, pWidth, pHeight));
        }

        public Node(Rect pRect) {
            this.mRect = pRect;
        }

        public Rect getRect() {
            return this.mRect;
        }

        public Node getChildA() {
            return this.mChildA;
        }

        public Node getChildB() {
            return this.mChildB;
        }

        public Node insert(ITextureAtlasSource pTextureAtlasSource, int pTextureWidth, int pTextureHeight, int pTextureAtlasSourceSpacing, int pTextureAtlasSourcePadding) throws IllegalArgumentException {
            boolean fitToRightWithoutSpacing;
            if (this.mChildA != null && this.mChildB != null) {
                Node newNode = this.mChildA.insert(pTextureAtlasSource, pTextureWidth, pTextureHeight, pTextureAtlasSourceSpacing, pTextureAtlasSourcePadding);
                if (newNode != null) {
                    return newNode;
                }
                return this.mChildB.insert(pTextureAtlasSource, pTextureWidth, pTextureHeight, pTextureAtlasSourceSpacing, pTextureAtlasSourcePadding);
            }
            if (this.mTextureAtlasSource != null) {
                return null;
            }
            int textureSourceWidth = pTextureAtlasSource.getTextureWidth() + 2 * pTextureAtlasSourcePadding;
            int textureSourceHeight = pTextureAtlasSource.getTextureHeight() + 2 * pTextureAtlasSourcePadding;
            int rectWidth = this.mRect.getWidth();
            int rectHeight = this.mRect.getHeight();
            if (textureSourceWidth > rectWidth || textureSourceHeight > rectHeight) {
                return null;
            }
            int textureSourceWidthWithSpacing = textureSourceWidth + pTextureAtlasSourceSpacing;
            int textureSourceHeightWithSpacing = textureSourceHeight + pTextureAtlasSourceSpacing;
            int rectLeft = this.mRect.getLeft();
            int rectTop = this.mRect.getTop();
            boolean fitToBottomWithoutSpacing = textureSourceHeight == rectHeight && rectTop + textureSourceHeight == pTextureHeight;
            boolean bl = fitToRightWithoutSpacing = textureSourceWidth == rectWidth && rectLeft + textureSourceWidth == pTextureWidth;
            if (textureSourceWidthWithSpacing == rectWidth) {
                if (textureSourceHeightWithSpacing == rectHeight) {
                    this.mTextureAtlasSource = pTextureAtlasSource;
                    return this;
                }
                if (fitToBottomWithoutSpacing) {
                    this.mTextureAtlasSource = pTextureAtlasSource;
                    return this;
                }
            }
            if (fitToRightWithoutSpacing) {
                if (textureSourceHeightWithSpacing == rectHeight) {
                    this.mTextureAtlasSource = pTextureAtlasSource;
                    return this;
                }
                if (fitToBottomWithoutSpacing) {
                    this.mTextureAtlasSource = pTextureAtlasSource;
                    return this;
                }
                if (textureSourceHeightWithSpacing > rectHeight) {
                    return null;
                }
                return this.createChildren(pTextureAtlasSource, pTextureWidth, pTextureHeight, pTextureAtlasSourceSpacing, pTextureAtlasSourcePadding, rectWidth - textureSourceWidth, rectHeight - textureSourceHeightWithSpacing);
            }
            if (fitToBottomWithoutSpacing) {
                if (textureSourceWidthWithSpacing == rectWidth) {
                    this.mTextureAtlasSource = pTextureAtlasSource;
                    return this;
                }
                if (textureSourceWidthWithSpacing > rectWidth) {
                    return null;
                }
                return this.createChildren(pTextureAtlasSource, pTextureWidth, pTextureHeight, pTextureAtlasSourceSpacing, pTextureAtlasSourcePadding, rectWidth - textureSourceWidthWithSpacing, rectHeight - textureSourceHeight);
            }
            if (textureSourceWidthWithSpacing > rectWidth || textureSourceHeightWithSpacing > rectHeight) {
                return null;
            }
            return this.createChildren(pTextureAtlasSource, pTextureWidth, pTextureHeight, pTextureAtlasSourceSpacing, pTextureAtlasSourcePadding, rectWidth - textureSourceWidthWithSpacing, rectHeight - textureSourceHeightWithSpacing);
        }

        private Node createChildren(ITextureAtlasSource pTextureAtlasSource, int pTextureWidth, int pTextureHeight, int pTextureAtlasSourceSpacing, int pTextureAtlasSourcePadding, int pDeltaWidth, int pDeltaHeight) {
            Rect rect = this.mRect;
            if (pDeltaWidth >= pDeltaHeight) {
                this.mChildA = new Node(rect.getLeft(), rect.getTop(), pTextureAtlasSource.getTextureWidth() + pTextureAtlasSourceSpacing + 2 * pTextureAtlasSourcePadding, rect.getHeight());
                this.mChildB = new Node(rect.getLeft() + (pTextureAtlasSource.getTextureWidth() + pTextureAtlasSourceSpacing + 2 * pTextureAtlasSourcePadding), rect.getTop(), rect.getWidth() - (pTextureAtlasSource.getTextureWidth() + pTextureAtlasSourceSpacing + 2 * pTextureAtlasSourcePadding), rect.getHeight());
            } else {
                this.mChildA = new Node(rect.getLeft(), rect.getTop(), rect.getWidth(), pTextureAtlasSource.getTextureHeight() + pTextureAtlasSourceSpacing + 2 * pTextureAtlasSourcePadding);
                this.mChildB = new Node(rect.getLeft(), rect.getTop() + (pTextureAtlasSource.getTextureHeight() + pTextureAtlasSourceSpacing + 2 * pTextureAtlasSourcePadding), rect.getWidth(), rect.getHeight() - (pTextureAtlasSource.getTextureHeight() + pTextureAtlasSourceSpacing + 2 * pTextureAtlasSourcePadding));
            }
            return this.mChildA.insert(pTextureAtlasSource, pTextureWidth, pTextureHeight, pTextureAtlasSourceSpacing, pTextureAtlasSourcePadding);
        }
    }

    protected static class Rect {
        private final int mLeft;
        private final int mTop;
        private final int mWidth;
        private final int mHeight;

        public Rect(int pLeft, int pTop, int pWidth, int pHeight) {
            this.mLeft = pLeft;
            this.mTop = pTop;
            this.mWidth = pWidth;
            this.mHeight = pHeight;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getLeft() {
            return this.mLeft;
        }

        public int getTop() {
            return this.mTop;
        }

        public int getRight() {
            return this.mLeft + this.mWidth;
        }

        public int getBottom() {
            return this.mTop + this.mHeight;
        }

        public String toString() {
            return "@: " + this.mLeft + "/" + this.mTop + " * " + this.mWidth + "x" + this.mHeight;
        }
    }
}

