/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.andengine.opengl.texture.ITextureStateListener;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.texture.Texture;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.texture.bitmap.BitmapTextureFormat;
import org.andengine.opengl.util.GLState;
import org.andengine.util.StreamUtils;
import org.andengine.util.adt.io.in.IInputStreamOpener;
import org.andengine.util.exception.NullBitmapException;
import org.andengine.util.math.MathUtils;

public class BitmapTexture
extends Texture {
    private final int mWidth;
    private final int mHeight;
    private final IInputStreamOpener mInputStreamOpener;
    private final BitmapTextureFormat mBitmapTextureFormat;

    public BitmapTexture(TextureManager pTextureManager, IInputStreamOpener pInputStreamOpener) throws IOException {
        this(pTextureManager, pInputStreamOpener, BitmapTextureFormat.RGBA_8888, TextureOptions.DEFAULT, null);
    }

    public BitmapTexture(TextureManager pTextureManager, IInputStreamOpener pInputStreamOpener, BitmapTextureFormat pBitmapTextureFormat) throws IOException {
        this(pTextureManager, pInputStreamOpener, pBitmapTextureFormat, TextureOptions.DEFAULT, null);
    }

    public BitmapTexture(TextureManager pTextureManager, IInputStreamOpener pInputStreamOpener, TextureOptions pTextureOptions) throws IOException {
        this(pTextureManager, pInputStreamOpener, BitmapTextureFormat.RGBA_8888, pTextureOptions, null);
    }

    public BitmapTexture(TextureManager pTextureManager, IInputStreamOpener pInputStreamOpener, BitmapTextureFormat pBitmapTextureFormat, TextureOptions pTextureOptions) throws IOException {
        this(pTextureManager, pInputStreamOpener, pBitmapTextureFormat, pTextureOptions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapTexture(TextureManager pTextureManager, IInputStreamOpener pInputStreamOpener, BitmapTextureFormat pBitmapTextureFormat, TextureOptions pTextureOptions, ITextureStateListener pTextureStateListener) throws IOException {
        super(pTextureManager, pBitmapTextureFormat.getPixelFormat(), pTextureOptions, pTextureStateListener);
        this.mInputStreamOpener = pInputStreamOpener;
        this.mBitmapTextureFormat = pBitmapTextureFormat;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inJustDecodeBounds = true;
        Closeable in = null;
        try {
            BitmapFactory.decodeStream((InputStream)pInputStreamOpener.open(), null, (BitmapFactory.Options)decodeOptions);
        }
        finally {
            StreamUtils.close(in);
        }
        this.mWidth = decodeOptions.outWidth;
        this.mHeight = decodeOptions.outHeight;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    protected void writeTextureToHardware(GLState pGLState) throws IOException {
        boolean preMultipyAlpha;
        boolean useDefaultAlignment;
        Bitmap.Config bitmapConfig = this.mBitmapTextureFormat.getBitmapConfig();
        Bitmap bitmap = this.onGetBitmap(bitmapConfig);
        if (bitmap == null) {
            throw new NullBitmapException("Caused by: '" + this.toString() + "'.");
        }
        boolean bl = useDefaultAlignment = MathUtils.isPowerOfTwo(bitmap.getWidth()) && MathUtils.isPowerOfTwo(bitmap.getHeight()) && this.mPixelFormat == PixelFormat.RGBA_8888;
        if (!useDefaultAlignment) {
            GLES20.glPixelStorei((int)3317, (int)1);
        }
        if (preMultipyAlpha = this.mTextureOptions.mPreMultiplyAlpha) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        } else {
            pGLState.glTexImage2D(3553, 0, bitmap, 0, this.mPixelFormat);
        }
        if (!useDefaultAlignment) {
            GLES20.glPixelStorei((int)3317, (int)4);
        }
        bitmap.recycle();
    }

    protected Bitmap onGetBitmap(Bitmap.Config pBitmapConfig) throws IOException {
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inPreferredConfig = pBitmapConfig;
        return BitmapFactory.decodeStream((InputStream)this.mInputStreamOpener.open(), null, (BitmapFactory.Options)decodeOptions);
    }
}

