/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.compressed.pvr.pixelbufferstrategy;

import android.opengl.GLES20;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.texture.compressed.pvr.PVRTexture;
import org.andengine.opengl.texture.compressed.pvr.pixelbufferstrategy.IPVRTexturePixelBufferStrategy;
import org.andengine.util.StreamUtils;
import org.andengine.util.exception.AndEngineRuntimeException;

public class SmartPVRTexturePixelBufferStrategy
implements IPVRTexturePixelBufferStrategy {
    private final int mAllocationSizeMaximum;

    public SmartPVRTexturePixelBufferStrategy(int pAllocationSizeMaximum) {
        this.mAllocationSizeMaximum = pAllocationSizeMaximum;
    }

    @Override
    public IPVRTexturePixelBufferStrategy.IPVRTexturePixelBufferStrategyBufferManager newPVRTexturePixelBufferStrategyManager(PVRTexture pPVRTexture) throws IOException {
        return new SmartPVRTexturePixelBufferStrategyBufferManager(pPVRTexture);
    }

    @Override
    public void loadPVRTextureData(IPVRTexturePixelBufferStrategy.IPVRTexturePixelBufferStrategyBufferManager pPVRTexturePixelBufferStrategyManager, int pWidth, int pHeight, int pBytesPerPixel, PixelFormat pPixelFormat, int pLevel, int pCurrentPixelDataOffset, int pCurrentPixelDataSize) throws IOException {
        int currentStripeHeight;
        int glFormat = pPixelFormat.getGLFormat();
        int glType = pPixelFormat.getGLType();
        GLES20.glTexImage2D((int)3553, (int)pLevel, (int)pPixelFormat.getGLInternalFormat(), (int)pWidth, (int)pHeight, (int)0, (int)glFormat, (int)glType, null);
        int bytesPerRow = pWidth * pBytesPerPixel;
        int stripeHeight = Math.max(1, this.mAllocationSizeMaximum / bytesPerRow);
        int currentStripePixelDataOffset = pCurrentPixelDataOffset;
        for (int currentStripeOffsetY = 0; currentStripeOffsetY < pHeight; currentStripeOffsetY += currentStripeHeight) {
            currentStripeHeight = Math.min(pHeight - currentStripeOffsetY, stripeHeight);
            int currentStripePixelDataSize = currentStripeHeight * bytesPerRow;
            ByteBuffer pixelBuffer = pPVRTexturePixelBufferStrategyManager.getPixelBuffer(52 + currentStripePixelDataOffset, currentStripePixelDataSize);
            GLES20.glTexSubImage2D((int)3553, (int)pLevel, (int)0, (int)currentStripeOffsetY, (int)pWidth, (int)currentStripeHeight, (int)glFormat, (int)glType, (Buffer)pixelBuffer);
            currentStripePixelDataOffset += currentStripePixelDataSize;
        }
    }

    public static class SmartPVRTexturePixelBufferStrategyBufferManager
    implements IPVRTexturePixelBufferStrategy.IPVRTexturePixelBufferStrategyBufferManager {
        private final InputStream mInputStream;
        private int mInputStreamPosition;
        private byte[] mData;

        public SmartPVRTexturePixelBufferStrategyBufferManager(PVRTexture pPVRTexture) throws IOException {
            this.mInputStream = pPVRTexture.getInputStream();
        }

        @Override
        public ByteBuffer getPixelBuffer(int pStart, int pByteCount) throws IOException {
            if (pStart < this.mInputStreamPosition) {
                throw new AndEngineRuntimeException("Cannot read data that has been read already. (pStart: '" + pStart + "', this.mInputStreamPosition: '" + this.mInputStreamPosition + "')");
            }
            if (this.mData == null || this.mData.length < pByteCount) {
                this.mData = new byte[pByteCount];
            }
            if (this.mInputStreamPosition < pStart) {
                int bytesToSkip = pStart - this.mInputStreamPosition;
                long skipped = this.mInputStream.skip(bytesToSkip);
                this.mInputStreamPosition = (int)((long)this.mInputStreamPosition + skipped);
                if ((long)bytesToSkip != skipped) {
                    throw new AndEngineRuntimeException("Skipped: '" + skipped + "' instead of '" + bytesToSkip + "'.");
                }
            }
            int bytesToRead = pStart + pByteCount - this.mInputStreamPosition;
            StreamUtils.streamToBytes(this.mInputStream, bytesToRead, this.mData);
            this.mInputStreamPosition += bytesToRead;
            return ByteBuffer.wrap(this.mData, 0, pByteCount);
        }
    }
}

