/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.region;

import org.andengine.opengl.texture.ITexture;
import org.andengine.opengl.texture.region.BaseTextureRegion;

public class TextureRegion
extends BaseTextureRegion {
    private static final float SCALE_DEFAULT = 1.0f;
    protected float mTextureX;
    protected float mTextureY;
    protected float mTextureWidth;
    protected float mTextureHeight;
    protected float mU;
    protected float mU2;
    protected float mV;
    protected float mV2;
    protected final float mScale;
    protected final boolean mRotated;

    public TextureRegion(ITexture pTexture, float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight) {
        this(pTexture, pTextureX, pTextureY, pTextureWidth, pTextureHeight, false);
    }

    public TextureRegion(ITexture pTexture, float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight, boolean pRotated) {
        this(pTexture, pTextureX, pTextureY, pTextureWidth, pTextureHeight, 1.0f, pRotated);
    }

    public TextureRegion(ITexture pTexture, float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight, float pScale) {
        this(pTexture, pTextureX, pTextureY, pTextureWidth, pTextureHeight, pScale, false);
    }

    public TextureRegion(ITexture pTexture, float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight, float pScale, boolean pRotated) {
        super(pTexture);
        this.mTextureX = pTextureX;
        this.mTextureY = pTextureY;
        if (pRotated) {
            this.mRotated = true;
            this.mTextureWidth = pTextureHeight;
            this.mTextureHeight = pTextureWidth;
        } else {
            this.mRotated = false;
            this.mTextureWidth = pTextureWidth;
            this.mTextureHeight = pTextureHeight;
        }
        this.mScale = pScale;
        this.updateUV();
    }

    @Override
    public TextureRegion deepCopy() {
        if (this.mRotated) {
            return new TextureRegion(this.mTexture, this.mTextureX, this.mTextureY, this.mTextureHeight, this.mTextureWidth, this.mScale, this.mRotated);
        }
        return new TextureRegion(this.mTexture, this.mTextureX, this.mTextureY, this.mTextureWidth, this.mTextureHeight, this.mScale, this.mRotated);
    }

    @Override
    public float getTextureX() {
        return this.mTextureX;
    }

    @Override
    public float getTextureY() {
        return this.mTextureY;
    }

    @Override
    public void setTextureX(float pTextureX) {
        this.mTextureX = pTextureX;
        this.updateUV();
    }

    @Override
    public void setTextureY(float pTextureY) {
        this.mTextureY = pTextureY;
        this.updateUV();
    }

    @Override
    public void setTexturePosition(float pTextureX, float pTextureY) {
        this.mTextureX = pTextureX;
        this.mTextureY = pTextureY;
        this.updateUV();
    }

    @Override
    public float getWidth() {
        if (this.mRotated) {
            return this.mTextureHeight * this.mScale;
        }
        return this.mTextureWidth * this.mScale;
    }

    @Override
    public float getHeight() {
        if (this.mRotated) {
            return this.mTextureWidth * this.mScale;
        }
        return this.mTextureHeight * this.mScale;
    }

    @Override
    public void setTextureWidth(float pTextureWidth) {
        this.mTextureWidth = pTextureWidth;
        this.updateUV();
    }

    @Override
    public void setTextureHeight(float pTextureHeight) {
        this.mTextureHeight = pTextureHeight;
        this.updateUV();
    }

    @Override
    public void setTextureSize(float pTextureWidth, float pTextureHeight) {
        this.mTextureWidth = pTextureWidth;
        this.mTextureHeight = pTextureHeight;
        this.updateUV();
    }

    @Override
    public void set(float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight) {
        this.mTextureX = pTextureX;
        this.mTextureY = pTextureY;
        this.mTextureWidth = pTextureWidth;
        this.mTextureHeight = pTextureHeight;
        this.updateUV();
    }

    @Override
    public float getU() {
        return this.mU;
    }

    @Override
    public float getU2() {
        return this.mU2;
    }

    @Override
    public float getV() {
        return this.mV;
    }

    @Override
    public float getV2() {
        return this.mV2;
    }

    @Override
    public boolean isScaled() {
        return this.mScale != 1.0f;
    }

    @Override
    public float getScale() {
        return this.mScale;
    }

    @Override
    public boolean isRotated() {
        return this.mRotated;
    }

    public void updateUV() {
        ITexture texture = this.mTexture;
        float textureWidth = texture.getWidth();
        float textureHeight = texture.getHeight();
        float x = this.getTextureX();
        float y = this.getTextureY();
        this.mU = x / textureWidth;
        this.mU2 = (x + this.mTextureWidth) / textureWidth;
        this.mV = y / textureHeight;
        this.mV2 = (y + this.mTextureHeight) / textureHeight;
    }
}

