/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.region;

import org.andengine.opengl.texture.ITexture;
import org.andengine.opengl.texture.region.BaseTextureRegion;
import org.andengine.opengl.texture.region.ITextureRegion;
import org.andengine.opengl.texture.region.ITiledTextureRegion;
import org.andengine.opengl.texture.region.TextureRegion;

public class TiledTextureRegion
extends BaseTextureRegion
implements ITiledTextureRegion {
    protected int mCurrentTileIndex;
    protected final int mTileCount;
    protected final ITextureRegion[] mTextureRegions;

    public TiledTextureRegion(ITexture pTexture, ITextureRegion ... pTextureRegions) {
        this(pTexture, true, pTextureRegions);
    }

    public TiledTextureRegion(ITexture pTexture, boolean pPerformSameTextureSanityCheck, ITextureRegion ... pTextureRegions) {
        super(pTexture);
        this.mTextureRegions = pTextureRegions;
        this.mTileCount = this.mTextureRegions.length;
        if (pPerformSameTextureSanityCheck) {
            for (int i = this.mTileCount - 1; i >= 0; --i) {
                if (pTextureRegions[i].getTexture() == pTexture) continue;
                throw new IllegalArgumentException("The " + ITextureRegion.class.getSimpleName() + ": '" + pTextureRegions[i].toString() + "' at index: '" + i + "' is not on the same " + ITexture.class.getSimpleName() + ": '" + pTextureRegions[i].getTexture().toString() + "' as the supplied " + ITexture.class.getSimpleName() + ": '" + pTexture.toString() + "'.");
            }
        }
    }

    public static TiledTextureRegion create(ITexture pTexture, int pTextureX, int pTextureY, int pTextureWidth, int pTextureHeight, int pTileColumns, int pTileRows) {
        return TiledTextureRegion.create(pTexture, pTextureX, pTextureY, pTextureWidth, pTextureHeight, pTileColumns, pTileRows, false);
    }

    public static TiledTextureRegion create(ITexture pTexture, int pTextureX, int pTextureY, int pTextureWidth, int pTextureHeight, int pTileColumns, int pTileRows, boolean pRotated) {
        ITextureRegion[] textureRegions = new ITextureRegion[pTileColumns * pTileRows];
        int tileWidth = pTextureWidth / pTileColumns;
        int tileHeight = pTextureHeight / pTileRows;
        for (int tileColumn = 0; tileColumn < pTileColumns; ++tileColumn) {
            for (int tileRow = 0; tileRow < pTileRows; ++tileRow) {
                int tileIndex = tileRow * pTileColumns + tileColumn;
                int x = pTextureX + tileColumn * tileWidth;
                int y = pTextureY + tileRow * tileHeight;
                textureRegions[tileIndex] = new TextureRegion(pTexture, (float)x, (float)y, (float)tileWidth, (float)tileHeight, pRotated);
            }
        }
        return new TiledTextureRegion(pTexture, false, textureRegions);
    }

    @Override
    public TiledTextureRegion deepCopy() {
        int tileCount = this.mTileCount;
        ITextureRegion[] textureRegions = new ITextureRegion[tileCount];
        for (int i = 0; i < tileCount; ++i) {
            textureRegions[i] = this.mTextureRegions[i].deepCopy();
        }
        return new TiledTextureRegion(this.mTexture, false, textureRegions);
    }

    @Override
    public int getCurrentTileIndex() {
        return this.mCurrentTileIndex;
    }

    @Override
    public void setCurrentTileIndex(int pCurrentTileIndex) {
        this.mCurrentTileIndex = pCurrentTileIndex;
    }

    @Override
    public void nextTile() {
        ++this.mCurrentTileIndex;
        if (this.mCurrentTileIndex >= this.mTileCount) {
            this.mCurrentTileIndex %= this.mTileCount;
        }
    }

    @Override
    public ITextureRegion getTextureRegion(int pTileIndex) {
        return this.mTextureRegions[pTileIndex];
    }

    @Override
    public int getTileCount() {
        return this.mTileCount;
    }

    @Override
    public float getTextureX() {
        return this.mTextureRegions[this.mCurrentTileIndex].getTextureX();
    }

    @Override
    public float getTextureX(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getTextureX();
    }

    @Override
    public float getTextureY() {
        return this.mTextureRegions[this.mCurrentTileIndex].getTextureY();
    }

    @Override
    public float getTextureY(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getTextureY();
    }

    @Override
    public void setTextureX(float pTextureX) {
        this.mTextureRegions[this.mCurrentTileIndex].setTextureX(pTextureX);
    }

    @Override
    public void setTextureX(int pTileIndex, float pTextureX) {
        this.mTextureRegions[pTileIndex].setTextureX(pTextureX);
    }

    @Override
    public void setTextureY(float pTextureY) {
        this.mTextureRegions[this.mCurrentTileIndex].setTextureY(pTextureY);
    }

    @Override
    public void setTextureY(int pTileIndex, float pTextureY) {
        this.mTextureRegions[pTileIndex].setTextureY(pTextureY);
    }

    @Override
    public void setTexturePosition(float pTextureX, float pTextureY) {
        this.mTextureRegions[this.mCurrentTileIndex].setTexturePosition(pTextureX, pTextureY);
    }

    @Override
    public void setTexturePosition(int pTileIndex, float pTextureX, float pTextureY) {
        this.mTextureRegions[pTileIndex].setTexturePosition(pTextureX, pTextureY);
    }

    @Override
    public float getWidth() {
        return this.mTextureRegions[this.mCurrentTileIndex].getWidth();
    }

    @Override
    public float getWidth(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getWidth();
    }

    @Override
    public float getHeight() {
        return this.mTextureRegions[this.mCurrentTileIndex].getHeight();
    }

    @Override
    public float getHeight(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getHeight();
    }

    @Override
    public void setTextureWidth(float pTextureWidth) {
        this.mTextureRegions[this.mCurrentTileIndex].setTextureWidth(pTextureWidth);
    }

    @Override
    public void setTextureWidth(int pTileIndex, float pTextureWidth) {
        this.mTextureRegions[pTileIndex].setTextureWidth(pTextureWidth);
    }

    @Override
    public void setTextureHeight(float pTextureHeight) {
        this.mTextureRegions[this.mCurrentTileIndex].setTextureHeight(pTextureHeight);
    }

    @Override
    public void setTextureHeight(int pTileIndex, float pTextureHeight) {
        this.mTextureRegions[pTileIndex].setTextureHeight(pTextureHeight);
    }

    @Override
    public void setTextureSize(float pTextureWidth, float pTextureHeight) {
        this.mTextureRegions[this.mCurrentTileIndex].setTextureSize(pTextureWidth, pTextureHeight);
    }

    @Override
    public void setTextureSize(int pTileIndex, float pTextureWidth, float pTextureHeight) {
        this.mTextureRegions[pTileIndex].setTextureSize(pTextureWidth, pTextureHeight);
    }

    @Override
    public void set(float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight) {
        this.mTextureRegions[this.mCurrentTileIndex].set(pTextureX, pTextureY, pTextureWidth, pTextureHeight);
    }

    @Override
    public void set(int pTileIndex, float pTextureX, float pTextureY, float pTextureWidth, float pTextureHeight) {
        this.mTextureRegions[pTileIndex].set(pTextureX, pTextureY, pTextureWidth, pTextureHeight);
    }

    @Override
    public float getU() {
        return this.mTextureRegions[this.mCurrentTileIndex].getU();
    }

    @Override
    public float getU(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getU();
    }

    @Override
    public float getV() {
        return this.mTextureRegions[this.mCurrentTileIndex].getV();
    }

    @Override
    public float getV(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getV();
    }

    @Override
    public float getU2() {
        return this.mTextureRegions[this.mCurrentTileIndex].getU2();
    }

    @Override
    public float getU2(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getU2();
    }

    @Override
    public float getV2() {
        return this.mTextureRegions[this.mCurrentTileIndex].getV2();
    }

    @Override
    public float getV2(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getV2();
    }

    @Override
    public boolean isScaled() {
        return this.mTextureRegions[this.mCurrentTileIndex].isScaled();
    }

    @Override
    public boolean isScaled(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].isScaled();
    }

    @Override
    public float getScale() {
        return this.mTextureRegions[this.mCurrentTileIndex].getScale();
    }

    @Override
    public float getScale(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].getScale();
    }

    @Override
    public boolean isRotated() {
        return this.mTextureRegions[this.mCurrentTileIndex].isRotated();
    }

    @Override
    public boolean isRotated(int pTileIndex) {
        return this.mTextureRegions[pTileIndex].isRotated();
    }
}

