/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.texture.render;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import org.andengine.opengl.exception.GLException;
import org.andengine.opengl.exception.GLFrameBufferException;
import org.andengine.opengl.exception.RenderTextureInitializationException;
import org.andengine.opengl.texture.ITextureStateListener;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.texture.Texture;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.texture.TextureOptions;
import org.andengine.opengl.util.GLHelper;
import org.andengine.opengl.util.GLState;
import org.andengine.util.color.Color;

public class RenderTexture
extends Texture {
    private static final int[] VIEWPORT_CONTAINER = new int[4];
    private static final float[] CLEARCOLOR_CONTAINER = new float[4];
    private static final int VIEWPORT_CONTAINER_X_INDEX = 0;
    private static final int VIEWPORT_CONTAINER_Y_INDEX = 1;
    private static final int VIEWPORT_CONTAINER_WIDTH_INDEX = 2;
    private static final int VIEWPORT_CONTAINER_HEIGHT_INDEX = 3;
    private static final int CLEARCOLOR_CONTAINER_RED_INDEX = 0;
    private static final int CLEARCOLOR_CONTAINER_GREEN_INDEX = 1;
    private static final int CLEARCOLOR_CONTAINER_BLUE_INDEX = 2;
    private static final int CLEARCOLOR_CONTAINER_ALPHA_INDEX = 3;
    protected final PixelFormat mPixelFormat;
    protected final int mWidth;
    protected final int mHeight;
    protected int mFramebufferObjectID;
    private int mPreviousFramebufferObjectID;
    private int mPreviousViewPortX;
    private int mPreviousViewPortY;
    private int mPreviousViewPortWidth;
    private int mPreviousViewPortHeight;
    private boolean mInitialized;

    public RenderTexture(TextureManager pTextureManager, int pWidth, int pHeight) {
        this(pTextureManager, pWidth, pHeight, PixelFormat.RGBA_8888, TextureOptions.NEAREST);
    }

    public RenderTexture(TextureManager pTextureManager, int pWidth, int pHeight, PixelFormat pPixelFormat) {
        this(pTextureManager, pWidth, pHeight, pPixelFormat, TextureOptions.NEAREST);
    }

    public RenderTexture(TextureManager pTextureManager, int pWidth, int pHeight, TextureOptions pTextureOptions) {
        this(pTextureManager, pWidth, pHeight, PixelFormat.RGBA_8888, pTextureOptions);
    }

    public RenderTexture(TextureManager pTextureManager, int pWidth, int pHeight, PixelFormat pPixelFormat, TextureOptions pTextureOptions) {
        this(pTextureManager, pWidth, pHeight, pPixelFormat, pTextureOptions, null);
    }

    public RenderTexture(TextureManager pTextureManager, int pWidth, int pHeight, PixelFormat pPixelFormat, TextureOptions pTextureOptions, ITextureStateListener pTextureStateListener) {
        super(pTextureManager, pPixelFormat, pTextureOptions, pTextureStateListener);
        this.mWidth = pWidth;
        this.mHeight = pHeight;
        this.mPixelFormat = pPixelFormat;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    @Override
    protected void writeTextureToHardware(GLState pGLState) {
        GLES20.glTexImage2D((int)3553, (int)0, (int)this.mPixelFormat.getGLInternalFormat(), (int)this.mWidth, (int)this.mHeight, (int)0, (int)this.mPixelFormat.getGLFormat(), (int)this.mPixelFormat.getGLType(), null);
    }

    public void init(GLState pGLState) throws GLFrameBufferException, GLException {
        this.savePreviousFramebufferObjectID(pGLState);
        try {
            this.loadToHardware(pGLState);
        }
        catch (IOException e) {
            // empty catch block
        }
        pGLState.bindTexture(0);
        this.mFramebufferObjectID = pGLState.generateFramebuffer();
        pGLState.bindFramebuffer(this.mFramebufferObjectID);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mHardwareTextureID, (int)0);
        try {
            pGLState.checkFramebufferStatus();
        }
        catch (GLException e) {
            this.destroy(pGLState);
            throw new RenderTextureInitializationException(e);
        }
        finally {
            this.restorePreviousFramebufferObjectID(pGLState);
        }
        this.mInitialized = true;
    }

    public void begin(GLState pGLState) {
        this.begin(pGLState, false, false);
    }

    public void begin(GLState pGLState, Color pColor) {
        this.begin(pGLState, pColor.getRed(), pColor.getGreen(), pColor.getBlue(), pColor.getAlpha());
    }

    public void begin(GLState pGLState, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.begin(pGLState, false, false, pRed, pGreen, pBlue, pAlpha);
    }

    public void begin(GLState pGLState, boolean pFlipX, boolean pFlipY, Color pColor) {
        this.begin(pGLState, pFlipX, pFlipY, pColor.getRed(), pColor.getGreen(), pColor.getBlue(), pColor.getAlpha());
    }

    public void begin(GLState pGLState, boolean pFlipX, boolean pFlipY, float pRed, float pGreen, float pBlue, float pAlpha) {
        this.begin(pGLState, pFlipX, pFlipY);
        GLES20.glGetFloatv((int)3106, (float[])CLEARCOLOR_CONTAINER, (int)0);
        GLES20.glClearColor((float)pRed, (float)pGreen, (float)pBlue, (float)pAlpha);
        GLES20.glClear((int)16384);
        GLES20.glClearColor((float)CLEARCOLOR_CONTAINER[0], (float)CLEARCOLOR_CONTAINER[1], (float)CLEARCOLOR_CONTAINER[2], (float)CLEARCOLOR_CONTAINER[3]);
    }

    public void begin(GLState pGLState, boolean pFlipX, boolean pFlipY) {
        float bottom;
        float top;
        float right;
        float left;
        this.savePreviousViewport();
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        pGLState.pushProjectionGLMatrix();
        if (pFlipX) {
            left = this.mWidth;
            right = 0.0f;
        } else {
            left = 0.0f;
            right = this.mWidth;
        }
        if (pFlipY) {
            top = this.mHeight;
            bottom = 0.0f;
        } else {
            top = 0.0f;
            bottom = this.mHeight;
        }
        pGLState.orthoProjectionGLMatrixf(left, right, bottom, top, -1.0f, 1.0f);
        this.savePreviousFramebufferObjectID(pGLState);
        pGLState.bindFramebuffer(this.mFramebufferObjectID);
        pGLState.pushModelViewGLMatrix();
        pGLState.loadModelViewGLMatrixIdentity();
    }

    public void flush(GLState pGLState) {
        pGLState.flush();
    }

    public void finish(GLState pGLState) {
        pGLState.finish();
    }

    public void end(GLState pGLState) {
        this.end(pGLState, false, false);
    }

    public void end(GLState pGLState, boolean pFlush, boolean pFinish) {
        if (pFinish) {
            this.finish(pGLState);
        } else if (pFlush) {
            this.flush(pGLState);
        }
        pGLState.popModelViewGLMatrix();
        this.restorePreviousFramebufferObjectID(pGLState);
        pGLState.popProjectionGLMatrix();
        this.resotorePreviousViewport();
    }

    public void destroy(GLState pGLState) {
        this.unloadFromHardware(pGLState);
        pGLState.deleteFramebuffer(this.mFramebufferObjectID);
        this.mInitialized = false;
    }

    protected void savePreviousFramebufferObjectID(GLState pGLState) {
        this.mPreviousFramebufferObjectID = pGLState.getActiveFramebuffer();
    }

    protected void restorePreviousFramebufferObjectID(GLState pGLState) {
        pGLState.bindFramebuffer(this.mPreviousFramebufferObjectID);
    }

    protected void savePreviousViewport() {
        GLES20.glGetIntegerv((int)2978, (int[])VIEWPORT_CONTAINER, (int)0);
        this.mPreviousViewPortX = VIEWPORT_CONTAINER[0];
        this.mPreviousViewPortY = VIEWPORT_CONTAINER[1];
        this.mPreviousViewPortWidth = VIEWPORT_CONTAINER[2];
        this.mPreviousViewPortHeight = VIEWPORT_CONTAINER[3];
    }

    protected void resotorePreviousViewport() {
        GLES20.glViewport((int)this.mPreviousViewPortX, (int)this.mPreviousViewPortY, (int)this.mPreviousViewPortWidth, (int)this.mPreviousViewPortHeight);
    }

    public int[] getPixelsARGB_8888(GLState pGLState) {
        return this.getPixelsARGB_8888(pGLState, 0, 0, this.mWidth, this.mHeight);
    }

    public int[] getPixelsARGB_8888(GLState pGLState, int pX, int pY, int pWidth, int pHeight) {
        int[] pixelsRGBA_8888 = new int[pWidth * pHeight];
        IntBuffer glPixelBuffer = IntBuffer.wrap(pixelsRGBA_8888);
        glPixelBuffer.position(0);
        this.begin(pGLState);
        GLES20.glReadPixels((int)pX, (int)pY, (int)pWidth, (int)pHeight, (int)this.mPixelFormat.getGLFormat(), (int)this.mPixelFormat.getGLType(), (Buffer)glPixelBuffer);
        this.end(pGLState);
        return GLHelper.convertRGBA_8888toARGB_8888(pixelsRGBA_8888);
    }

    public Bitmap getBitmap(GLState pGLState) {
        return this.getBitmap(pGLState, 0, 0, this.mWidth, this.mHeight);
    }

    public Bitmap getBitmap(GLState pGLState, int pX, int pY, int pWidth, int pHeight) {
        if (this.mPixelFormat != PixelFormat.RGBA_8888) {
            throw new IllegalStateException("Currently only 'PixelFormat." + (Object)((Object)PixelFormat.RGBA_8888) + "' is supported to be retrieved as a Bitmap.");
        }
        return Bitmap.createBitmap((int[])this.getPixelsARGB_8888(pGLState, pX, pY, pWidth, pHeight), (int)pWidth, (int)pHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

