/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.util;

import java.nio.ByteBuffer;
import org.andengine.util.debug.Debug;
import org.andengine.util.system.SystemUtils;

public class BufferUtils {
    private static final boolean NATIVE_LIB_LOADED;
    private static final boolean WORKAROUND_BYTEBUFFER_PUT_FLOATARRAY;
    private static final boolean WORKAROUND_BYTEBUFFER_ALLOCATE_DIRECT;

    public static ByteBuffer allocateDirectByteBuffer(int pCapacity) {
        if (WORKAROUND_BYTEBUFFER_ALLOCATE_DIRECT) {
            return BufferUtils.jniAllocateDirect(pCapacity);
        }
        return ByteBuffer.allocateDirect(pCapacity);
    }

    public static void freeDirectByteBuffer(ByteBuffer pByteBuffer) {
        if (WORKAROUND_BYTEBUFFER_ALLOCATE_DIRECT) {
            BufferUtils.jniFreeDirect(pByteBuffer);
        }
    }

    private static native ByteBuffer jniAllocateDirect(int var0);

    private static native void jniFreeDirect(ByteBuffer var0);

    public static void put(ByteBuffer pByteBuffer, float[] pSource, int pLength, int pOffset) {
        if (WORKAROUND_BYTEBUFFER_PUT_FLOATARRAY) {
            BufferUtils.jniPut(pByteBuffer, pSource, pLength, pOffset);
        } else {
            for (int i = pOffset; i < pOffset + pLength; ++i) {
                pByteBuffer.putFloat(pSource[i]);
            }
        }
        pByteBuffer.position(0);
        pByteBuffer.limit(pLength << 2);
    }

    private static native void jniPut(ByteBuffer var0, float[] var1, int var2, int var3);

    public static short getUnsignedByte(ByteBuffer pByteBuffer) {
        return (short)(pByteBuffer.get() & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer pByteBuffer, int pValue) {
        pByteBuffer.put((byte)(pValue & 0xFF));
    }

    public static short getUnsignedByte(ByteBuffer pByteBuffer, int pPosition) {
        return (short)(pByteBuffer.get(pPosition) & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer pByteBuffer, int pPosition, int pValue) {
        pByteBuffer.put(pPosition, (byte)(pValue & 0xFF));
    }

    public static int getUnsignedShort(ByteBuffer pByteBuffer) {
        return pByteBuffer.getShort() & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer pByteBuffer, int pValue) {
        pByteBuffer.putShort((short)(pValue & 0xFFFF));
    }

    public static int getUnsignedShort(ByteBuffer pByteBuffer, int pPosition) {
        return pByteBuffer.getShort(pPosition) & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer pByteBuffer, int pPosition, int pValue) {
        pByteBuffer.putShort(pPosition, (short)(pValue & 0xFFFF));
    }

    public static long getUnsignedInt(ByteBuffer pByteBuffer) {
        return (long)pByteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer pByteBuffer, long pValue) {
        pByteBuffer.putInt((int)(pValue & 0xFFFFFFFFL));
    }

    public static long getUnsignedInt(ByteBuffer pByteBuffer, int pPosition) {
        return (long)pByteBuffer.getInt(pPosition) & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer pByteBuffer, int pPosition, long pValue) {
        pByteBuffer.putInt(pPosition, (short)(pValue & 0xFFFFFFFFL));
    }

    static {
        boolean loadLibrarySuccess;
        try {
            System.loadLibrary("andengine");
            loadLibrarySuccess = true;
        }
        catch (UnsatisfiedLinkError pUnsatisfiedLinkError) {
            loadLibrarySuccess = false;
        }
        NATIVE_LIB_LOADED = loadLibrarySuccess;
        if (NATIVE_LIB_LOADED) {
            WORKAROUND_BYTEBUFFER_ALLOCATE_DIRECT = SystemUtils.isAndroidVersion(11, 13);
            WORKAROUND_BYTEBUFFER_PUT_FLOATARRAY = SystemUtils.isAndroidVersionOrLower(8);
        } else {
            WORKAROUND_BYTEBUFFER_ALLOCATE_DIRECT = false;
            if (SystemUtils.isAndroidVersion(11, 13)) {
                Debug.w("Creating a " + ByteBuffer.class.getSimpleName() + " will actually allocate 4x the memory than requested!");
            }
            WORKAROUND_BYTEBUFFER_PUT_FLOATARRAY = false;
        }
    }
}

