/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.util;

import android.graphics.Bitmap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.andengine.opengl.texture.PixelFormat;

public class GLHelper {
    public static Buffer getPixels(Bitmap pBitmap, PixelFormat pPixelFormat) {
        return GLHelper.getPixels(pBitmap, pPixelFormat, ByteOrder.nativeOrder());
    }

    public static Buffer getPixels(Bitmap pBitmap, PixelFormat pPixelFormat, ByteOrder pByteOrder) {
        int[] pixelsARGB_8888 = GLHelper.getPixelsARGB_8888(pBitmap);
        switch (pPixelFormat) {
            case RGB_565: {
                return ShortBuffer.wrap(GLHelper.convertARGB_8888toRGB_565(pixelsARGB_8888, pByteOrder));
            }
            case RGBA_8888: {
                ByteOrder reverseByteOrder = pByteOrder == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                return IntBuffer.wrap(GLHelper.convertARGB_8888toRGBA_8888(pixelsARGB_8888, reverseByteOrder));
            }
            case RGBA_4444: {
                return ShortBuffer.wrap(GLHelper.convertARGB_8888toRGBA_4444(pixelsARGB_8888, pByteOrder));
            }
            case A_8: {
                return ByteBuffer.wrap(GLHelper.convertARGB_8888toA_8(pixelsARGB_8888));
            }
        }
        throw new IllegalArgumentException("Unexpected " + PixelFormat.class.getSimpleName() + ": '" + (Object)((Object)pPixelFormat) + "'.");
    }

    public static int[] convertARGB_8888toRGBA_8888(int[] pPixelsARGB_8888) {
        return GLHelper.convertARGB_8888toRGBA_8888(pPixelsARGB_8888, ByteOrder.nativeOrder());
    }

    public static int[] convertARGB_8888toRGBA_8888(int[] pPixelsARGB_8888, ByteOrder pByteOrder) {
        if (pByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsARGB_8888[i];
                pPixelsARGB_8888[i] = pixel & 0xFF00FF00 | pixel << 16 & 0xFF0000 | pixel >> 16 & 0xFF;
            }
        } else {
            for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsARGB_8888[i];
                pPixelsARGB_8888[i] = pixel << 8 & 0xFFFFFF00 | pixel >> 24 & 0xFF;
            }
        }
        return pPixelsARGB_8888;
    }

    public static short[] convertARGB_8888toRGB_565(int[] pPixelsARGB_8888) {
        return GLHelper.convertARGB_8888toRGB_565(pPixelsARGB_8888, ByteOrder.nativeOrder());
    }

    public static short[] convertARGB_8888toRGB_565(int[] pPixelsARGB_8888, ByteOrder pByteOrder) {
        short[] pixelsRGB_565 = new short[pPixelsARGB_8888.length];
        if (pByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsARGB_8888[i];
                pixelsRGB_565[i] = (short)(pixel >> 16 & 0xF8 | pixel >> 13 & 7 | pixel << 3 & 0xE000 | pixel << 5 & 0x1F00);
            }
        } else {
            for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsARGB_8888[i];
                pixelsRGB_565[i] = (short)(pixel >> 8 & 0xF800 | pixel >> 5 & 0x7E0 | pixel >> 3 & 0x1F);
            }
        }
        return pixelsRGB_565;
    }

    public static short[] convertARGB_8888toRGBA_4444(int[] pPixelsARGB_8888) {
        return GLHelper.convertARGB_8888toRGBA_4444(pPixelsARGB_8888, ByteOrder.nativeOrder());
    }

    public static short[] convertARGB_8888toRGBA_4444(int[] pPixelsARGB_8888, ByteOrder pByteOrder) {
        short[] pixelsRGBA_4444 = new short[pPixelsARGB_8888.length];
        if (pByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsARGB_8888[i];
                pixelsRGBA_4444[i] = (short)(pixel >> 16 & 0xF0 | pixel >> 12 & 0xF | pixel << 8 & 0xF000 | pixel >> 20 & 0xF00);
            }
        } else {
            for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsARGB_8888[i];
                pixelsRGBA_4444[i] = (short)(pixel >> 8 & 0xF000 | pixel >> 4 & 0xF00 | pixel & 0xF0 | pixel >> 28 & 0xF);
            }
        }
        return pixelsRGBA_4444;
    }

    public static byte[] convertARGB_8888toA_8(int[] pPixelsARGB_8888) {
        byte[] pixelsA_8 = new byte[pPixelsARGB_8888.length];
        for (int i = pPixelsARGB_8888.length - 1; i >= 0; --i) {
            pixelsA_8[i] = (byte)(pPixelsARGB_8888[i] >> 24 & 0xFF);
        }
        return pixelsA_8;
    }

    public static int[] getPixelsARGB_8888(Bitmap pBitmap) {
        int w = pBitmap.getWidth();
        int h = pBitmap.getHeight();
        int[] pixelsARGB_8888 = new int[w * h];
        pBitmap.getPixels(pixelsARGB_8888, 0, w, 0, 0, w, h);
        return pixelsARGB_8888;
    }

    public static int[] convertRGBA_8888toARGB_8888(int[] pPixelsRGBA_8888) {
        return GLHelper.convertRGBA_8888toARGB_8888(pPixelsRGBA_8888, ByteOrder.nativeOrder());
    }

    public static int[] convertRGBA_8888toARGB_8888(int[] pPixelsRGBA_8888, ByteOrder pByteOrder) {
        if (pByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int i = pPixelsRGBA_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsRGBA_8888[i];
                pPixelsRGBA_8888[i] = pixel & 0xFF00FF00 | pixel << 16 & 0xFF0000 | pixel >> 16 & 0xFF;
            }
        } else {
            for (int i = pPixelsRGBA_8888.length - 1; i >= 0; --i) {
                int pixel = pPixelsRGBA_8888[i];
                pPixelsRGBA_8888[i] = pixel >> 8 & 0xFFFFFF | pixel << 24 & 0xFF000000;
            }
        }
        return pPixelsRGBA_8888;
    }

    public static int[] convertRGBA_8888toARGB_8888_FlippedVertical(int[] pPixelsRGBA_8888, int pWidth, int pHeight) {
        return GLHelper.convertRGBA_8888toARGB_8888_FlippedVertical(pPixelsRGBA_8888, pWidth, pHeight, ByteOrder.nativeOrder());
    }

    public static int[] convertRGBA_8888toARGB_8888_FlippedVertical(int[] pPixelsRGBA_8888, int pWidth, int pHeight, ByteOrder pByteOrder) {
        int[] pixelsARGB_8888 = new int[pWidth * pHeight];
        if (pByteOrder == ByteOrder.LITTLE_ENDIAN) {
            for (int y = 0; y < pHeight; ++y) {
                for (int x = 0; x < pWidth; ++x) {
                    int pixel = pPixelsRGBA_8888[x + y * pWidth];
                    pixelsARGB_8888[x + (pHeight - y - 1) * pWidth] = pixel & 0xFF00FF00 | pixel << 16 & 0xFF0000 | pixel >> 16 & 0xFF;
                }
            }
        } else {
            for (int y = 0; y < pHeight; ++y) {
                for (int x = 0; x < pWidth; ++x) {
                    int pixel = pPixelsRGBA_8888[x + y * pWidth];
                    pixelsARGB_8888[x + (pHeight - y - 1) * pWidth] = pixel >> 8 & 0xFFFFFF | pixel << 24 & 0xFF000000;
                }
            }
        }
        return pixelsARGB_8888;
    }
}

