/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.util;

import android.opengl.Matrix;
import org.andengine.util.exception.AndEngineRuntimeException;

public class GLMatrixStack {
    public static final int GLMATRIXSTACK_DEPTH_MAX = 32;
    public static final int GLMATRIX_SIZE = 16;
    private static final int GLMATRIXSTACKOFFSET_UNDERFLOW = -16;
    private static final int GLMATRIXSTACKOFFSET_OVERFLOW = 512;
    final float[] mMatrixStack = new float[512];
    int mMatrixStackOffset;
    private final float[] mTemp = new float[32];

    public GLMatrixStack() {
        this.glLoadIdentity();
    }

    public void getMatrix(float[] pMatrix) {
        System.arraycopy(this.mMatrixStack, this.mMatrixStackOffset, pMatrix, 0, 16);
    }

    public void glLoadIdentity() {
        Matrix.setIdentityM((float[])this.mMatrixStack, (int)this.mMatrixStackOffset);
    }

    public void glTranslatef(float pX, float pY, float pZ) {
        Matrix.translateM((float[])this.mMatrixStack, (int)this.mMatrixStackOffset, (float)pX, (float)pY, (float)pZ);
    }

    public void glRotatef(float pAngle, float pX, float pY, float pZ) {
        Matrix.setRotateM((float[])this.mTemp, (int)0, (float)pAngle, (float)pX, (float)pY, (float)pZ);
        System.arraycopy(this.mMatrixStack, this.mMatrixStackOffset, this.mTemp, 16, 16);
        Matrix.multiplyMM((float[])this.mMatrixStack, (int)this.mMatrixStackOffset, (float[])this.mTemp, (int)16, (float[])this.mTemp, (int)0);
    }

    public void glScalef(float pScaleX, float pScaleY, float pScaleZ) {
        Matrix.scaleM((float[])this.mMatrixStack, (int)this.mMatrixStackOffset, (float)pScaleX, (float)pScaleY, (float)pScaleZ);
    }

    public void glSkewf(float pSkewX, float pSkewY) {
        GLMatrixStack.setSkewM(this.mTemp, 0, pSkewX, pSkewY);
        System.arraycopy(this.mMatrixStack, this.mMatrixStackOffset, this.mTemp, 16, 16);
        Matrix.multiplyMM((float[])this.mMatrixStack, (int)this.mMatrixStackOffset, (float[])this.mTemp, (int)16, (float[])this.mTemp, (int)0);
    }

    public void glOrthof(float pLeft, float pRight, float pBottom, float pTop, float pZNear, float pZFar) {
        Matrix.orthoM((float[])this.mMatrixStack, (int)this.mMatrixStackOffset, (float)pLeft, (float)pRight, (float)pBottom, (float)pTop, (float)pZNear, (float)pZFar);
    }

    public void glPushMatrix() throws GLMatrixStackOverflowException {
        if (this.mMatrixStackOffset + 16 >= 512) {
            throw new GLMatrixStackOverflowException();
        }
        System.arraycopy(this.mMatrixStack, this.mMatrixStackOffset, this.mMatrixStack, this.mMatrixStackOffset + 16, 16);
        this.mMatrixStackOffset += 16;
    }

    public void glPopMatrix() {
        if (this.mMatrixStackOffset - 16 <= -16) {
            throw new GLMatrixStackUnderflowException();
        }
        this.mMatrixStackOffset -= 16;
    }

    public void reset() {
        this.mMatrixStackOffset = 0;
        this.glLoadIdentity();
    }

    private static void setSkewM(float[] pMatrixStack, int pOffset, float pSkewX, float pSkewY) {
        pMatrixStack[pOffset + 0] = 1.0f;
        pMatrixStack[pOffset + 1] = (float)Math.tan((float)(-Math.PI) / 180 * pSkewY);
        pMatrixStack[pOffset + 2] = 0.0f;
        pMatrixStack[pOffset + 3] = 0.0f;
        pMatrixStack[pOffset + 4] = (float)Math.tan((float)(-Math.PI) / 180 * pSkewX);
        pMatrixStack[pOffset + 5] = 1.0f;
        pMatrixStack[pOffset + 6] = 0.0f;
        pMatrixStack[pOffset + 7] = 0.0f;
        pMatrixStack[pOffset + 8] = 0.0f;
        pMatrixStack[pOffset + 9] = 0.0f;
        pMatrixStack[pOffset + 10] = 1.0f;
        pMatrixStack[pOffset + 11] = 0.0f;
        pMatrixStack[pOffset + 12] = 0.0f;
        pMatrixStack[pOffset + 13] = 0.0f;
        pMatrixStack[pOffset + 14] = 0.0f;
        pMatrixStack[pOffset + 15] = 1.0f;
    }

    public static class GLMatrixStackUnderflowException
    extends AndEngineRuntimeException {
        private static final long serialVersionUID = -3268021423136372954L;
    }

    public static class GLMatrixStackOverflowException
    extends AndEngineRuntimeException {
        private static final long serialVersionUID = -800847781599300100L;
    }
}

