/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.util;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.microedition.khronos.egl.EGLConfig;
import org.andengine.engine.options.RenderOptions;
import org.andengine.opengl.exception.GLException;
import org.andengine.opengl.exception.GLFrameBufferException;
import org.andengine.opengl.texture.PixelFormat;
import org.andengine.opengl.util.GLHelper;
import org.andengine.opengl.util.GLMatrixStack;
import org.andengine.opengl.view.ConfigChooser;

public class GLState {
    public static final int GL_UNPACK_ALIGNMENT_DEFAULT = 4;
    private final int[] mHardwareIDContainer = new int[1];
    private String mVersion;
    private String mRenderer;
    private String mExtensions;
    private int mMaximumVertexAttributeCount;
    private int mMaximumVertexShaderUniformVectorCount;
    private int mMaximumFragmentShaderUniformVectorCount;
    private int mMaximumTextureSize;
    private int mMaximumTextureUnits;
    private int mCurrentArrayBufferID = -1;
    private int mCurrentIndexBufferID = -1;
    private int mCurrentShaderProgramID = -1;
    private final int[] mCurrentBoundTextureIDs = new int[31];
    private int mCurrentFramebufferID = -1;
    private int mCurrentActiveTextureIndex = 0;
    private int mCurrentSourceBlendMode = -1;
    private int mCurrentDestinationBlendMode = -1;
    private boolean mDitherEnabled = true;
    private boolean mDepthTestEnabled = true;
    private boolean mScissorTestEnabled = false;
    private boolean mBlendEnabled = false;
    private boolean mCullingEnabled = false;
    private float mLineWidth = 1.0f;
    private final GLMatrixStack mModelViewGLMatrixStack = new GLMatrixStack();
    private final GLMatrixStack mProjectionGLMatrixStack = new GLMatrixStack();
    private final float[] mModelViewGLMatrix = new float[16];
    private final float[] mProjectionGLMatrix = new float[16];
    private final float[] mModelViewProjectionGLMatrix = new float[16];

    public String getVersion() {
        return this.mVersion;
    }

    public String getRenderer() {
        return this.mRenderer;
    }

    public String getExtensions() {
        return this.mExtensions;
    }

    public int getMaximumVertexAttributeCount() {
        return this.mMaximumVertexAttributeCount;
    }

    public int getMaximumVertexShaderUniformVectorCount() {
        return this.mMaximumVertexShaderUniformVectorCount;
    }

    public int getMaximumFragmentShaderUniformVectorCount() {
        return this.mMaximumFragmentShaderUniformVectorCount;
    }

    public int getMaximumTextureUnits() {
        return this.mMaximumTextureUnits;
    }

    public int getMaximumTextureSize() {
        return this.mMaximumTextureSize;
    }

    public void reset(RenderOptions pRenderOptions, ConfigChooser pConfigChooser, EGLConfig pEGLConfig) {
        this.mVersion = GLES20.glGetString((int)7938);
        this.mRenderer = GLES20.glGetString((int)7937);
        this.mExtensions = GLES20.glGetString((int)7939);
        this.mMaximumVertexAttributeCount = this.getInteger(34921);
        this.mMaximumVertexShaderUniformVectorCount = this.getInteger(36347);
        this.mMaximumFragmentShaderUniformVectorCount = this.getInteger(36349);
        this.mMaximumTextureUnits = this.getInteger(34930);
        this.mMaximumTextureSize = this.getInteger(3379);
        this.mModelViewGLMatrixStack.reset();
        this.mProjectionGLMatrixStack.reset();
        this.mCurrentArrayBufferID = -1;
        this.mCurrentIndexBufferID = -1;
        this.mCurrentShaderProgramID = -1;
        Arrays.fill(this.mCurrentBoundTextureIDs, -1);
        this.mCurrentFramebufferID = -1;
        this.mCurrentActiveTextureIndex = 0;
        this.mCurrentSourceBlendMode = -1;
        this.mCurrentDestinationBlendMode = -1;
        this.enableDither();
        this.enableDepthTest();
        this.disableBlend();
        this.disableCulling();
        GLES20.glEnableVertexAttribArray((int)0);
        GLES20.glEnableVertexAttribArray((int)1);
        GLES20.glEnableVertexAttribArray((int)3);
        this.mLineWidth = 1.0f;
    }

    public boolean isScissorTestEnabled() {
        return this.mScissorTestEnabled;
    }

    public boolean enableScissorTest() {
        if (this.mScissorTestEnabled) {
            return true;
        }
        this.mScissorTestEnabled = true;
        GLES20.glEnable((int)3089);
        return false;
    }

    public boolean disableScissorTest() {
        if (!this.mScissorTestEnabled) {
            return false;
        }
        this.mScissorTestEnabled = false;
        GLES20.glDisable((int)3089);
        return true;
    }

    public boolean setScissorTestEnabled(boolean pEnabled) {
        if (pEnabled) {
            return this.enableScissorTest();
        }
        return this.disableScissorTest();
    }

    public boolean isBlendEnabled() {
        return this.mBlendEnabled;
    }

    public boolean enableBlend() {
        if (this.mBlendEnabled) {
            return true;
        }
        this.mBlendEnabled = true;
        GLES20.glEnable((int)3042);
        return false;
    }

    public boolean disableBlend() {
        if (!this.mBlendEnabled) {
            return false;
        }
        this.mBlendEnabled = false;
        GLES20.glDisable((int)3042);
        return true;
    }

    public boolean setBlendEnabled(boolean pEnabled) {
        if (pEnabled) {
            return this.enableBlend();
        }
        return this.disableBlend();
    }

    public boolean isCullingEnabled() {
        return this.mCullingEnabled;
    }

    public boolean enableCulling() {
        if (this.mCullingEnabled) {
            return true;
        }
        this.mCullingEnabled = true;
        GLES20.glEnable((int)2884);
        return false;
    }

    public boolean disableCulling() {
        if (!this.mCullingEnabled) {
            return false;
        }
        this.mCullingEnabled = false;
        GLES20.glDisable((int)2884);
        return true;
    }

    public boolean setCullingEnabled(boolean pEnabled) {
        if (pEnabled) {
            return this.enableCulling();
        }
        return this.disableCulling();
    }

    public boolean isDitherEnabled() {
        return this.mDitherEnabled;
    }

    public boolean enableDither() {
        if (this.mDitherEnabled) {
            return true;
        }
        this.mDitherEnabled = true;
        GLES20.glEnable((int)3024);
        return false;
    }

    public boolean disableDither() {
        if (!this.mDitherEnabled) {
            return false;
        }
        this.mDitherEnabled = false;
        GLES20.glDisable((int)3024);
        return true;
    }

    public boolean setDitherEnabled(boolean pEnabled) {
        if (pEnabled) {
            return this.enableDither();
        }
        return this.disableDither();
    }

    public boolean isDepthTestEnabled() {
        return this.mDepthTestEnabled;
    }

    public boolean enableDepthTest() {
        if (this.mDepthTestEnabled) {
            return true;
        }
        this.mDepthTestEnabled = true;
        GLES20.glEnable((int)2929);
        return false;
    }

    public boolean disableDepthTest() {
        if (!this.mDepthTestEnabled) {
            return false;
        }
        this.mDepthTestEnabled = false;
        GLES20.glDisable((int)2929);
        return true;
    }

    public boolean setDepthTestEnabled(boolean pEnabled) {
        if (pEnabled) {
            return this.enableDepthTest();
        }
        return this.disableDepthTest();
    }

    public int generateBuffer() {
        GLES20.glGenBuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
        return this.mHardwareIDContainer[0];
    }

    public int generateArrayBuffer(int pSize, int pUsage) {
        GLES20.glGenBuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
        int hardwareBufferID = this.mHardwareIDContainer[0];
        this.bindArrayBuffer(hardwareBufferID);
        GLES20.glBufferData((int)34962, (int)pSize, null, (int)pUsage);
        this.bindArrayBuffer(0);
        return hardwareBufferID;
    }

    public void bindArrayBuffer(int pHardwareBufferID) {
        if (this.mCurrentArrayBufferID != pHardwareBufferID) {
            this.mCurrentArrayBufferID = pHardwareBufferID;
            GLES20.glBindBuffer((int)34962, (int)pHardwareBufferID);
        }
    }

    public void deleteArrayBuffer(int pHardwareBufferID) {
        if (this.mCurrentArrayBufferID == pHardwareBufferID) {
            this.mCurrentArrayBufferID = -1;
        }
        this.mHardwareIDContainer[0] = pHardwareBufferID;
        GLES20.glDeleteBuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
    }

    public int generateIndexBuffer(int pSize, int pUsage) {
        GLES20.glGenBuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
        int hardwareBufferID = this.mHardwareIDContainer[0];
        this.bindIndexBuffer(hardwareBufferID);
        GLES20.glBufferData((int)34963, (int)pSize, null, (int)pUsage);
        this.bindIndexBuffer(0);
        return hardwareBufferID;
    }

    public void bindIndexBuffer(int pHardwareBufferID) {
        if (this.mCurrentIndexBufferID != pHardwareBufferID) {
            this.mCurrentIndexBufferID = pHardwareBufferID;
            GLES20.glBindBuffer((int)34963, (int)pHardwareBufferID);
        }
    }

    public void deleteIndexBuffer(int pHardwareBufferID) {
        if (this.mCurrentIndexBufferID == pHardwareBufferID) {
            this.mCurrentIndexBufferID = -1;
        }
        this.mHardwareIDContainer[0] = pHardwareBufferID;
        GLES20.glDeleteBuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
    }

    public int generateFramebuffer() {
        GLES20.glGenFramebuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
        return this.mHardwareIDContainer[0];
    }

    public void bindFramebuffer(int pFramebufferID) {
        GLES20.glBindFramebuffer((int)36160, (int)pFramebufferID);
    }

    public int getFramebufferStatus() {
        return GLES20.glCheckFramebufferStatus((int)36160);
    }

    public void checkFramebufferStatus() throws GLFrameBufferException, GLException {
        int framebufferStatus = this.getFramebufferStatus();
        switch (framebufferStatus) {
            case 36053: {
                return;
            }
            case 36061: {
                throw new GLFrameBufferException(framebufferStatus, "GL_FRAMEBUFFER_UNSUPPORTED");
            }
            case 36054: {
                throw new GLFrameBufferException(framebufferStatus, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            case 36057: {
                throw new GLFrameBufferException(framebufferStatus, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS");
            }
            case 36055: {
                throw new GLFrameBufferException(framebufferStatus, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            case 0: {
                this.checkError();
            }
        }
        throw new GLFrameBufferException(framebufferStatus);
    }

    public int getActiveFramebuffer() {
        return this.getInteger(36006);
    }

    public void deleteFramebuffer(int pHardwareFramebufferID) {
        if (this.mCurrentFramebufferID == pHardwareFramebufferID) {
            this.mCurrentFramebufferID = -1;
        }
        this.mHardwareIDContainer[0] = pHardwareFramebufferID;
        GLES20.glDeleteFramebuffers((int)1, (int[])this.mHardwareIDContainer, (int)0);
    }

    public void useProgram(int pShaderProgramID) {
        if (this.mCurrentShaderProgramID != pShaderProgramID) {
            this.mCurrentShaderProgramID = pShaderProgramID;
            GLES20.glUseProgram((int)pShaderProgramID);
        }
    }

    public void deleteProgram(int pShaderProgramID) {
        if (this.mCurrentShaderProgramID == pShaderProgramID) {
            this.mCurrentShaderProgramID = -1;
        }
        GLES20.glDeleteProgram((int)pShaderProgramID);
    }

    public int generateTexture() {
        GLES20.glGenTextures((int)1, (int[])this.mHardwareIDContainer, (int)0);
        return this.mHardwareIDContainer[0];
    }

    public boolean isTexture(int pHardwareTextureID) {
        return GLES20.glIsTexture((int)pHardwareTextureID);
    }

    public int getActiveTexture() {
        return this.mCurrentActiveTextureIndex + 33984;
    }

    public void activeTexture(int pGLActiveTexture) {
        int activeTextureIndex = pGLActiveTexture - 33984;
        if (pGLActiveTexture != this.mCurrentActiveTextureIndex) {
            this.mCurrentActiveTextureIndex = activeTextureIndex;
            GLES20.glActiveTexture((int)pGLActiveTexture);
        }
    }

    public void bindTexture(int pHardwareTextureID) {
        if (this.mCurrentBoundTextureIDs[this.mCurrentActiveTextureIndex] != pHardwareTextureID) {
            this.mCurrentBoundTextureIDs[this.mCurrentActiveTextureIndex] = pHardwareTextureID;
            GLES20.glBindTexture((int)3553, (int)pHardwareTextureID);
        }
    }

    public void deleteTexture(int pHardwareTextureID) {
        if (this.mCurrentBoundTextureIDs[this.mCurrentActiveTextureIndex] == pHardwareTextureID) {
            this.mCurrentBoundTextureIDs[this.mCurrentActiveTextureIndex] = -1;
        }
        this.mHardwareIDContainer[0] = pHardwareTextureID;
        GLES20.glDeleteTextures((int)1, (int[])this.mHardwareIDContainer, (int)0);
    }

    public void blendFunction(int pSourceBlendMode, int pDestinationBlendMode) {
        if (this.mCurrentSourceBlendMode != pSourceBlendMode || this.mCurrentDestinationBlendMode != pDestinationBlendMode) {
            this.mCurrentSourceBlendMode = pSourceBlendMode;
            this.mCurrentDestinationBlendMode = pDestinationBlendMode;
            GLES20.glBlendFunc((int)pSourceBlendMode, (int)pDestinationBlendMode);
        }
    }

    public void lineWidth(float pLineWidth) {
        if (this.mLineWidth != pLineWidth) {
            this.mLineWidth = pLineWidth;
            GLES20.glLineWidth((float)pLineWidth);
        }
    }

    public void pushModelViewGLMatrix() {
        this.mModelViewGLMatrixStack.glPushMatrix();
    }

    public void popModelViewGLMatrix() {
        this.mModelViewGLMatrixStack.glPopMatrix();
    }

    public void loadModelViewGLMatrixIdentity() {
        this.mModelViewGLMatrixStack.glLoadIdentity();
    }

    public void translateModelViewGLMatrixf(float pX, float pY, float pZ) {
        this.mModelViewGLMatrixStack.glTranslatef(pX, pY, pZ);
    }

    public void rotateModelViewGLMatrixf(float pAngle, float pX, float pY, float pZ) {
        this.mModelViewGLMatrixStack.glRotatef(pAngle, pX, pY, pZ);
    }

    public void scaleModelViewGLMatrixf(float pScaleX, float pScaleY, int pScaleZ) {
        this.mModelViewGLMatrixStack.glScalef(pScaleX, pScaleY, pScaleZ);
    }

    public void skewModelViewGLMatrixf(float pSkewX, float pSkewY) {
        this.mModelViewGLMatrixStack.glSkewf(pSkewX, pSkewY);
    }

    public void orthoModelViewGLMatrixf(float pLeft, float pRight, float pBottom, float pTop, float pZNear, float pZFar) {
        this.mModelViewGLMatrixStack.glOrthof(pLeft, pRight, pBottom, pTop, pZNear, pZFar);
    }

    public void pushProjectionGLMatrix() {
        this.mProjectionGLMatrixStack.glPushMatrix();
    }

    public void popProjectionGLMatrix() {
        this.mProjectionGLMatrixStack.glPopMatrix();
    }

    public void loadProjectionGLMatrixIdentity() {
        this.mProjectionGLMatrixStack.glLoadIdentity();
    }

    public void translateProjectionGLMatrixf(float pX, float pY, float pZ) {
        this.mProjectionGLMatrixStack.glTranslatef(pX, pY, pZ);
    }

    public void rotateProjectionGLMatrixf(float pAngle, float pX, float pY, float pZ) {
        this.mProjectionGLMatrixStack.glRotatef(pAngle, pX, pY, pZ);
    }

    public void scaleProjectionGLMatrixf(float pScaleX, float pScaleY, float pScaleZ) {
        this.mProjectionGLMatrixStack.glScalef(pScaleX, pScaleY, pScaleZ);
    }

    public void skewProjectionGLMatrixf(float pSkewX, float pSkewY) {
        this.mProjectionGLMatrixStack.glSkewf(pSkewX, pSkewY);
    }

    public void orthoProjectionGLMatrixf(float pLeft, float pRight, float pBottom, float pTop, float pZNear, float pZFar) {
        this.mProjectionGLMatrixStack.glOrthof(pLeft, pRight, pBottom, pTop, pZNear, pZFar);
    }

    public float[] getModelViewGLMatrix() {
        this.mModelViewGLMatrixStack.getMatrix(this.mModelViewGLMatrix);
        return this.mModelViewGLMatrix;
    }

    public float[] getProjectionGLMatrix() {
        this.mProjectionGLMatrixStack.getMatrix(this.mProjectionGLMatrix);
        return this.mProjectionGLMatrix;
    }

    public float[] getModelViewProjectionGLMatrix() {
        Matrix.multiplyMM((float[])this.mModelViewProjectionGLMatrix, (int)0, (float[])this.mProjectionGLMatrixStack.mMatrixStack, (int)this.mProjectionGLMatrixStack.mMatrixStackOffset, (float[])this.mModelViewGLMatrixStack.mMatrixStack, (int)this.mModelViewGLMatrixStack.mMatrixStackOffset);
        return this.mModelViewProjectionGLMatrix;
    }

    public void resetModelViewGLMatrixStack() {
        this.mModelViewGLMatrixStack.reset();
    }

    public void resetProjectionGLMatrixStack() {
        this.mProjectionGLMatrixStack.reset();
    }

    public void resetGLMatrixStacks() {
        this.mModelViewGLMatrixStack.reset();
        this.mProjectionGLMatrixStack.reset();
    }

    public void glTexImage2D(int pTarget, int pLevel, Bitmap pBitmap, int pBorder, PixelFormat pPixelFormat) {
        Buffer pixelBuffer = GLHelper.getPixels(pBitmap, pPixelFormat, ByteOrder.BIG_ENDIAN);
        GLES20.glTexImage2D((int)pTarget, (int)pLevel, (int)pPixelFormat.getGLInternalFormat(), (int)pBitmap.getWidth(), (int)pBitmap.getHeight(), (int)pBorder, (int)pPixelFormat.getGLFormat(), (int)pPixelFormat.getGLType(), (Buffer)pixelBuffer);
    }

    public void glTexSubImage2D(int pTarget, int pLevel, int pX, int pY, Bitmap pBitmap, PixelFormat pPixelFormat) {
        Buffer pixelBuffer = GLHelper.getPixels(pBitmap, pPixelFormat, ByteOrder.BIG_ENDIAN);
        GLES20.glTexSubImage2D((int)pTarget, (int)pLevel, (int)pX, (int)pY, (int)pBitmap.getWidth(), (int)pBitmap.getHeight(), (int)pPixelFormat.getGLFormat(), (int)pPixelFormat.getGLType(), (Buffer)pixelBuffer);
    }

    public void flush() {
        GLES20.glFlush();
    }

    public void finish() {
        GLES20.glFinish();
    }

    public int getInteger(int pAttribute) {
        GLES20.glGetIntegerv((int)pAttribute, (int[])this.mHardwareIDContainer, (int)0);
        return this.mHardwareIDContainer[0];
    }

    public int getError() {
        return GLES20.glGetError();
    }

    public void checkError() throws GLException {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new GLException(error);
        }
    }

    public void clearError() {
        GLES20.glGetError();
    }
}

