/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.vbo;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.andengine.opengl.util.BufferUtils;
import org.andengine.opengl.vbo.DrawType;
import org.andengine.opengl.vbo.VertexBufferObject;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.opengl.vbo.attribute.VertexBufferObjectAttributes;
import org.andengine.util.system.SystemUtils;

public class HighPerformanceVertexBufferObject
extends VertexBufferObject {
    protected final float[] mBufferData;
    protected final FloatBuffer mFloatBuffer;

    public HighPerformanceVertexBufferObject(VertexBufferObjectManager pVertexBufferObjectManager, int pCapacity, DrawType pDrawType, boolean pAutoDispose, VertexBufferObjectAttributes pVertexBufferObjectAttributes) {
        super(pVertexBufferObjectManager, pCapacity, pDrawType, pAutoDispose, pVertexBufferObjectAttributes);
        this.mBufferData = new float[pCapacity];
        this.mFloatBuffer = SystemUtils.SDK_VERSION_HONEYCOMB_OR_LATER ? this.mByteBuffer.asFloatBuffer() : null;
    }

    public HighPerformanceVertexBufferObject(VertexBufferObjectManager pVertexBufferObjectManager, float[] pBufferData, DrawType pDrawType, boolean pAutoDispose, VertexBufferObjectAttributes pVertexBufferObjectAttributes) {
        super(pVertexBufferObjectManager, pBufferData.length, pDrawType, pAutoDispose, pVertexBufferObjectAttributes);
        this.mBufferData = pBufferData;
        this.mFloatBuffer = SystemUtils.SDK_VERSION_HONEYCOMB_OR_LATER ? this.mByteBuffer.asFloatBuffer() : null;
    }

    public float[] getBufferData() {
        return this.mBufferData;
    }

    @Override
    public int getHeapMemoryByteSize() {
        return this.getByteCapacity();
    }

    @Override
    public int getNativeHeapMemoryByteSize() {
        return this.getByteCapacity();
    }

    @Override
    protected void onBufferData() {
        if (SystemUtils.SDK_VERSION_HONEYCOMB_OR_LATER) {
            this.mFloatBuffer.position(0);
            this.mFloatBuffer.put(this.mBufferData);
            GLES20.glBufferData((int)34962, (int)this.mByteBuffer.capacity(), (Buffer)this.mByteBuffer, (int)this.mUsage);
        } else {
            BufferUtils.put(this.mByteBuffer, this.mBufferData, this.mBufferData.length, 0);
            GLES20.glBufferData((int)34962, (int)this.mByteBuffer.limit(), (Buffer)this.mByteBuffer, (int)this.mUsage);
        }
    }
}

