/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.vbo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.ReentrantLock;
import org.andengine.opengl.util.BufferUtils;
import org.andengine.opengl.vbo.DrawType;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.opengl.vbo.ZeroMemoryVertexBufferObject;
import org.andengine.opengl.vbo.attribute.VertexBufferObjectAttributes;

public abstract class SharedMemoryVertexBufferObject
extends ZeroMemoryVertexBufferObject {
    private static ReentrantLock sSharedByteBufferLock = new ReentrantLock(true);
    private static ByteBuffer sSharedByteBuffer;

    public static int getSharedByteBufferByteCapacity() {
        int byteCapacity;
        try {
            sSharedByteBufferLock.lock();
            ByteBuffer sharedByteBuffer = sSharedByteBuffer;
            byteCapacity = sharedByteBuffer == null ? 0 : sharedByteBuffer.capacity();
        }
        finally {
            sSharedByteBufferLock.unlock();
        }
        return byteCapacity;
    }

    public SharedMemoryVertexBufferObject(VertexBufferObjectManager pVertexBufferObjectManager, int pCapacity, DrawType pDrawType, VertexBufferObjectAttributes pVertexBufferObjectAttributes) {
        super(pVertexBufferObjectManager, pCapacity, pDrawType, false, pVertexBufferObjectAttributes);
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            sSharedByteBufferLock.lock();
            if (sSharedByteBuffer != null) {
                BufferUtils.freeDirectByteBuffer(sSharedByteBuffer);
                sSharedByteBuffer = null;
            }
        }
        finally {
            sSharedByteBufferLock.unlock();
        }
    }

    @Override
    protected ByteBuffer aquireByteBuffer() {
        sSharedByteBufferLock.lock();
        int byteCapacity = this.getByteCapacity();
        if (sSharedByteBuffer == null || sSharedByteBuffer.capacity() < byteCapacity) {
            if (sSharedByteBuffer != null) {
                BufferUtils.freeDirectByteBuffer(sSharedByteBuffer);
            }
            sSharedByteBuffer = BufferUtils.allocateDirectByteBuffer(byteCapacity);
            sSharedByteBuffer.order(ByteOrder.nativeOrder());
        }
        sSharedByteBuffer.limit(byteCapacity);
        return sSharedByteBuffer;
    }

    @Override
    protected void releaseByteBuffer(ByteBuffer byteBuffer) {
        sSharedByteBufferLock.unlock();
    }
}

