/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.vbo;

import android.opengl.GLES20;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.andengine.opengl.shader.ShaderProgram;
import org.andengine.opengl.util.BufferUtils;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.vbo.DrawType;
import org.andengine.opengl.vbo.IVertexBufferObject;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.opengl.vbo.attribute.VertexBufferObjectAttributes;
import org.andengine.util.IDisposable;

public abstract class VertexBufferObject
implements IVertexBufferObject {
    protected final int mCapacity;
    protected final boolean mAutoDispose;
    protected final int mUsage;
    protected final ByteBuffer mByteBuffer;
    protected int mHardwareBufferID = -1;
    protected boolean mDirtyOnHardware = true;
    protected boolean mDisposed;
    protected final VertexBufferObjectManager mVertexBufferObjectManager;
    protected final VertexBufferObjectAttributes mVertexBufferObjectAttributes;

    public VertexBufferObject(VertexBufferObjectManager pVertexBufferObjectManager, int pCapacity, DrawType pDrawType, boolean pAutoDispose, VertexBufferObjectAttributes pVertexBufferObjectAttributes) {
        this.mVertexBufferObjectManager = pVertexBufferObjectManager;
        this.mCapacity = pCapacity;
        this.mUsage = pDrawType.getUsage();
        this.mAutoDispose = pAutoDispose;
        this.mVertexBufferObjectAttributes = pVertexBufferObjectAttributes;
        this.mByteBuffer = BufferUtils.allocateDirectByteBuffer(pCapacity * 4);
        this.mByteBuffer.order(ByteOrder.nativeOrder());
    }

    @Override
    public VertexBufferObjectManager getVertexBufferObjectManager() {
        return this.mVertexBufferObjectManager;
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    @Override
    public boolean isAutoDispose() {
        return this.mAutoDispose;
    }

    @Override
    public int getHardwareBufferID() {
        return this.mHardwareBufferID;
    }

    @Override
    public boolean isLoadedToHardware() {
        return this.mHardwareBufferID != -1;
    }

    @Override
    public void setNotLoadedToHardware() {
        this.mHardwareBufferID = -1;
        this.mDirtyOnHardware = true;
    }

    @Override
    public boolean isDirtyOnHardware() {
        return this.mDirtyOnHardware;
    }

    @Override
    public void setDirtyOnHardware() {
        this.mDirtyOnHardware = true;
    }

    @Override
    public int getCapacity() {
        return this.mCapacity;
    }

    @Override
    public int getByteCapacity() {
        return this.mByteBuffer.capacity();
    }

    @Override
    public int getGPUMemoryByteSize() {
        if (this.isLoadedToHardware()) {
            return this.getByteCapacity();
        }
        return 0;
    }

    protected abstract void onBufferData();

    @Override
    public void bind(GLState pGLState) {
        if (this.mHardwareBufferID == -1) {
            this.loadToHardware(pGLState);
            if (this.mVertexBufferObjectManager != null) {
                this.mVertexBufferObjectManager.onVertexBufferObjectLoaded(this);
            }
        }
        pGLState.bindArrayBuffer(this.mHardwareBufferID);
        if (this.mDirtyOnHardware) {
            this.onBufferData();
            this.mDirtyOnHardware = false;
        }
    }

    @Override
    public void bind(GLState pGLState, ShaderProgram pShaderProgram) {
        this.bind(pGLState);
        pShaderProgram.bind(pGLState, this.mVertexBufferObjectAttributes);
    }

    @Override
    public void unbind(GLState pGLState, ShaderProgram pShaderProgram) {
        pShaderProgram.unbind(pGLState);
    }

    @Override
    public void unloadFromHardware(GLState pGLState) {
        pGLState.deleteArrayBuffer(this.mHardwareBufferID);
        this.mHardwareBufferID = -1;
    }

    @Override
    public void draw(int pPrimitiveType, int pCount) {
        GLES20.glDrawArrays((int)pPrimitiveType, (int)0, (int)pCount);
    }

    @Override
    public void draw(int pPrimitiveType, int pOffset, int pCount) {
        GLES20.glDrawArrays((int)pPrimitiveType, (int)pOffset, (int)pCount);
    }

    @Override
    public void dispose() {
        if (!this.mDisposed) {
            this.mDisposed = true;
            if (this.mVertexBufferObjectManager != null) {
                this.mVertexBufferObjectManager.onUnloadVertexBufferObject(this);
            }
        } else {
            throw new IDisposable.AlreadyDisposedException();
        }
        BufferUtils.freeDirectByteBuffer(this.mByteBuffer);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.mDisposed) {
            this.dispose();
        }
    }

    private void loadToHardware(GLState pGLState) {
        this.mHardwareBufferID = pGLState.generateBuffer();
        this.mDirtyOnHardware = true;
    }
}

