/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.view;

import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class ConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final int[] BUFFER = new int[1];
    private static final int RED_SIZE = 5;
    private static final int GREEN_SIZE = 6;
    private static final int BLUE_SIZE = 5;
    private static final int DEPTH_SIZE = 0;
    private static final int ALPHA_SIZE = 0;
    private static final int STENCIL_SIZE = 0;
    private static final int MULTISAMPLE_COUNT = 2;
    private static final int EGL_GLES2_BIT = 4;
    private static final int[] EGLCONFIG_ATTRIBUTES_MULTISAMPLE = new int[]{12324, 5, 12323, 6, 12322, 5, 12321, 0, 12325, 0, 12326, 0, 12352, 4, 12338, 1, 12337, 2, 12344};
    private static final int EGL_COVERAGE_BUFFERS_NV = 12512;
    private static final int EGL_COVERAGE_SAMPLES_NV = 12513;
    private static final int[] EGLCONFIG_ATTRIBUTES_COVERAGEMULTISAMPLE_NVIDIA = new int[]{12324, 5, 12323, 6, 12322, 5, 12321, 0, 12325, 0, 12326, 0, 12352, 4, 12512, 1, 12513, 2, 12344};
    private static final int[] EGLCONFIG_ATTRIBUTES_FALLBACK = new int[]{12324, 5, 12323, 6, 12322, 5, 12321, 0, 12325, 0, 12326, 0, 12352, 4, 12344};
    private final boolean mMultiSamplingRequested;
    private boolean mMultiSampling;
    private boolean mCoverageMultiSampling;
    private int mRedSize = -1;
    private int mGreenSize = -1;
    private int mBlueSize = -1;
    private int mAlphaSize = -1;
    private int mDepthSize = -1;
    private int mStencilSize = -1;

    public ConfigChooser(boolean pMultiSamplingRequested) {
        this.mMultiSamplingRequested = pMultiSamplingRequested;
    }

    public boolean isMultiSampling() {
        return this.mMultiSampling;
    }

    public boolean isCoverageMultiSampling() {
        return this.mCoverageMultiSampling;
    }

    public int getRedSize() {
        return this.mRedSize;
    }

    public int getGreenSize() {
        return this.mGreenSize;
    }

    public int getBlueSize() {
        return this.mBlueSize;
    }

    public int getAlphaSize() {
        return this.mAlphaSize;
    }

    public int getDepthSize() {
        return this.mDepthSize;
    }

    public int getStencilSize() {
        return this.mStencilSize;
    }

    public EGLConfig chooseConfig(EGL10 pEGL, EGLDisplay pEGLDisplay) {
        try {
            return this.chooseConfig(pEGL, pEGLDisplay, ConfigChooserMatcher.STRICT);
        }
        catch (IllegalArgumentException e) {
            try {
                return this.chooseConfig(pEGL, pEGLDisplay, ConfigChooserMatcher.LOOSE_STENCIL);
            }
            catch (IllegalArgumentException e2) {
                try {
                    return this.chooseConfig(pEGL, pEGLDisplay, ConfigChooserMatcher.LOOSE_DEPTH_AND_STENCIL);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return this.chooseConfig(pEGL, pEGLDisplay, ConfigChooserMatcher.ANY);
                }
            }
        }
    }

    private EGLConfig chooseConfig(EGL10 pEGL, EGLDisplay pEGLDisplay, ConfigChooserMatcher pConfigChooserMatcher) throws IllegalArgumentException {
        int eglConfigCount;
        ConfigChooser.BUFFER[0] = 0;
        if (this.mMultiSamplingRequested) {
            eglConfigCount = ConfigChooser.getEGLConfigCount(pEGL, pEGLDisplay, EGLCONFIG_ATTRIBUTES_MULTISAMPLE);
            if (eglConfigCount > 0) {
                this.mMultiSampling = true;
                return this.findEGLConfig(pEGL, pEGLDisplay, EGLCONFIG_ATTRIBUTES_MULTISAMPLE, eglConfigCount, pConfigChooserMatcher);
            }
            eglConfigCount = ConfigChooser.getEGLConfigCount(pEGL, pEGLDisplay, EGLCONFIG_ATTRIBUTES_COVERAGEMULTISAMPLE_NVIDIA);
            if (eglConfigCount > 0) {
                this.mCoverageMultiSampling = true;
                return this.findEGLConfig(pEGL, pEGLDisplay, EGLCONFIG_ATTRIBUTES_COVERAGEMULTISAMPLE_NVIDIA, eglConfigCount, pConfigChooserMatcher);
            }
        }
        if ((eglConfigCount = ConfigChooser.getEGLConfigCount(pEGL, pEGLDisplay, EGLCONFIG_ATTRIBUTES_FALLBACK)) > 0) {
            return this.findEGLConfig(pEGL, pEGLDisplay, EGLCONFIG_ATTRIBUTES_FALLBACK, eglConfigCount, pConfigChooserMatcher);
        }
        throw new IllegalArgumentException("No " + EGLConfig.class.getSimpleName() + " found!");
    }

    private static int getEGLConfigCount(EGL10 pEGL, EGLDisplay pEGLDisplay, int[] pEGLConfigAttributes) {
        if (!pEGL.eglChooseConfig(pEGLDisplay, pEGLConfigAttributes, null, 0, BUFFER)) {
            throw new IllegalArgumentException("EGLCONFIG_FALLBACK failed!");
        }
        return BUFFER[0];
    }

    private EGLConfig findEGLConfig(EGL10 pEGL, EGLDisplay pEGLDisplay, int[] pEGLConfigAttributes, int pEGLConfigCount, ConfigChooserMatcher pConfigChooserMatcher) {
        EGLConfig[] eglConfigs = new EGLConfig[pEGLConfigCount];
        if (!pEGL.eglChooseConfig(pEGLDisplay, pEGLConfigAttributes, eglConfigs, pEGLConfigCount, BUFFER)) {
            throw new IllegalArgumentException("findEGLConfig failed!");
        }
        return this.findEGLConfig(pEGL, pEGLDisplay, eglConfigs, pConfigChooserMatcher);
    }

    private EGLConfig findEGLConfig(EGL10 pEGL, EGLDisplay pEGLDisplay, EGLConfig[] pEGLConfigs, ConfigChooserMatcher pConfigChooserMatcher) {
        for (int i = 0; i < pEGLConfigs.length; ++i) {
            int stencilSize;
            int depthSize;
            int alphaSize;
            int blueSize;
            int greenSize;
            int redSize;
            EGLConfig config = pEGLConfigs[i];
            if (config == null || !pConfigChooserMatcher.matches(redSize = ConfigChooser.getConfigAttrib(pEGL, pEGLDisplay, config, 12324, 0), greenSize = ConfigChooser.getConfigAttrib(pEGL, pEGLDisplay, config, 12323, 0), blueSize = ConfigChooser.getConfigAttrib(pEGL, pEGLDisplay, config, 12322, 0), alphaSize = ConfigChooser.getConfigAttrib(pEGL, pEGLDisplay, config, 12321, 0), depthSize = ConfigChooser.getConfigAttrib(pEGL, pEGLDisplay, config, 12325, 0), stencilSize = ConfigChooser.getConfigAttrib(pEGL, pEGLDisplay, config, 12326, 0))) continue;
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
            return config;
        }
        throw new IllegalArgumentException("No EGLConfig found!");
    }

    private static int getConfigAttrib(EGL10 pEGL, EGLDisplay pEGLDisplay, EGLConfig pEGLConfig, int pAttribute, int pDefaultValue) {
        if (pEGL.eglGetConfigAttrib(pEGLDisplay, pEGLConfig, pAttribute, BUFFER)) {
            return BUFFER[0];
        }
        return pDefaultValue;
    }

    public static enum ConfigChooserMatcher {
        STRICT{

            @Override
            public boolean matches(int pRedSize, int pGreenSize, int pBlueSize, int pAlphaSize, int pDepthSize, int pStencilSize) {
                return pDepthSize == 0 && pStencilSize == 0 && pRedSize == 5 && pGreenSize == 6 && pBlueSize == 5 && pAlphaSize == 0;
            }
        }
        ,
        LOOSE_STENCIL{

            @Override
            public boolean matches(int pRedSize, int pGreenSize, int pBlueSize, int pAlphaSize, int pDepthSize, int pStencilSize) {
                return pDepthSize == 0 && pStencilSize >= 0 && pRedSize == 5 && pGreenSize == 6 && pBlueSize == 5 && pAlphaSize == 0;
            }
        }
        ,
        LOOSE_DEPTH_AND_STENCIL{

            @Override
            public boolean matches(int pRedSize, int pGreenSize, int pBlueSize, int pAlphaSize, int pDepthSize, int pStencilSize) {
                return pDepthSize >= 0 && pStencilSize >= 0 && pRedSize == 5 && pGreenSize == 6 && pBlueSize == 5 && pAlphaSize == 0;
            }
        }
        ,
        ANY{

            @Override
            public boolean matches(int pRedSize, int pGreenSize, int pBlueSize, int pAlphaSize, int pDepthSize, int pStencilSize) {
                return true;
            }
        };


        public abstract boolean matches(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

