/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.view;

import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.andengine.engine.Engine;
import org.andengine.engine.options.RenderOptions;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.view.ConfigChooser;
import org.andengine.opengl.view.IRendererListener;
import org.andengine.util.debug.Debug;

public class EngineRenderer
implements GLSurfaceView.Renderer {
    final Engine mEngine;
    final ConfigChooser mConfigChooser;
    final boolean mMultiSampling;
    final IRendererListener mRendererListener;
    final GLState mGLState;

    public EngineRenderer(Engine pEngine, ConfigChooser pConfigChooser, IRendererListener pRendererListener) {
        this.mEngine = pEngine;
        this.mConfigChooser = pConfigChooser;
        this.mRendererListener = pRendererListener;
        this.mGLState = new GLState();
        this.mMultiSampling = this.mEngine.getEngineOptions().getRenderOptions().isMultiSampling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceCreated(GL10 pGL, EGLConfig pEGLConfig) {
        Class<GLState> clazz = GLState.class;
        synchronized (GLState.class) {
            RenderOptions renderOptions = this.mEngine.getEngineOptions().getRenderOptions();
            this.mGLState.reset(renderOptions, this.mConfigChooser, pEGLConfig);
            this.mGLState.disableDepthTest();
            this.mGLState.enableBlend();
            this.mGLState.setDitherEnabled(renderOptions.isDithering());
            if (this.mRendererListener != null) {
                this.mRendererListener.onSurfaceCreated(this.mGLState);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void onSurfaceChanged(GL10 pGL, int pWidth, int pHeight) {
        this.mEngine.setSurfaceSize(pWidth, pHeight);
        GLES20.glViewport((int)0, (int)0, (int)pWidth, (int)pHeight);
        this.mGLState.loadProjectionGLMatrixIdentity();
        if (this.mRendererListener != null) {
            this.mRendererListener.onSurfaceChanged(this.mGLState, pWidth, pHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 pGL) {
        Class<GLState> clazz = GLState.class;
        synchronized (GLState.class) {
            if (this.mMultiSampling && this.mConfigChooser.isCoverageMultiSampling()) {
                int GL_COVERAGE_BUFFER_BIT_NV = 32768;
                GLES20.glClear((int)32768);
            }
            try {
                this.mEngine.onDrawFrame(this.mGLState);
            }
            catch (InterruptedException e) {
                Debug.e("GLThread interrupted!", e);
            }
            return;
        }
    }
}

