/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.opengl.view;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import org.andengine.engine.Engine;
import org.andengine.opengl.view.ConfigChooser;
import org.andengine.opengl.view.EngineRenderer;
import org.andengine.opengl.view.IRendererListener;

public class RenderSurfaceView
extends GLSurfaceView {
    private EngineRenderer mEngineRenderer;
    private ConfigChooser mConfigChooser;

    public RenderSurfaceView(Context pContext) {
        super(pContext);
        this.setEGLContextClientVersion(2);
    }

    public RenderSurfaceView(Context pContext, AttributeSet pAttrs) {
        super(pContext, pAttrs);
        this.setEGLContextClientVersion(2);
    }

    public ConfigChooser getConfigChooser() throws IllegalStateException {
        if (this.mConfigChooser == null) {
            throw new IllegalStateException(ConfigChooser.class.getSimpleName() + " not yet set.");
        }
        return this.mConfigChooser;
    }

    protected void onMeasure(int pWidthMeasureSpec, int pHeightMeasureSpec) {
        if (this.isInEditMode()) {
            super.onMeasure(pWidthMeasureSpec, pHeightMeasureSpec);
            return;
        }
        this.mEngineRenderer.mEngine.getEngineOptions().getResolutionPolicy().onMeasure(this, pWidthMeasureSpec, pHeightMeasureSpec);
    }

    public void setMeasuredDimensionProxy(int pMeasuredWidth, int pMeasuredHeight) {
        this.setMeasuredDimension(pMeasuredWidth, pMeasuredHeight);
    }

    public void setRenderer(Engine pEngine, IRendererListener pRendererListener) {
        if (this.mConfigChooser == null) {
            boolean multiSampling = pEngine.getEngineOptions().getRenderOptions().isMultiSampling();
            this.mConfigChooser = new ConfigChooser(multiSampling);
        }
        this.setEGLConfigChooser(this.mConfigChooser);
        this.setOnTouchListener(pEngine);
        this.mEngineRenderer = new EngineRenderer(pEngine, this.mConfigChooser, pRendererListener);
        this.setRenderer(this.mEngineRenderer);
    }
}

