/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.PowerManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.andengine.audio.music.MusicManager;
import org.andengine.audio.sound.SoundManager;
import org.andengine.engine.Engine;
import org.andengine.engine.options.EngineOptions;
import org.andengine.engine.options.ScreenOrientation;
import org.andengine.engine.options.WakeLockOptions;
import org.andengine.entity.scene.Scene;
import org.andengine.input.sensor.acceleration.AccelerationSensorOptions;
import org.andengine.input.sensor.acceleration.IAccelerationListener;
import org.andengine.input.sensor.location.ILocationListener;
import org.andengine.input.sensor.location.LocationSensorOptions;
import org.andengine.input.sensor.orientation.IOrientationListener;
import org.andengine.input.sensor.orientation.OrientationSensorOptions;
import org.andengine.opengl.font.FontManager;
import org.andengine.opengl.shader.ShaderProgramManager;
import org.andengine.opengl.texture.TextureManager;
import org.andengine.opengl.util.GLState;
import org.andengine.opengl.vbo.VertexBufferObjectManager;
import org.andengine.opengl.view.IRendererListener;
import org.andengine.opengl.view.RenderSurfaceView;
import org.andengine.ui.IGameInterface;
import org.andengine.ui.activity.BaseActivity;
import org.andengine.util.ActivityUtils;
import org.andengine.util.debug.Debug;
import org.andengine.util.system.SystemUtils;

public abstract class BaseGameActivity
extends BaseActivity
implements IGameInterface,
IRendererListener {
    protected Engine mEngine;
    private PowerManager.WakeLock mWakeLock;
    protected RenderSurfaceView mRenderSurfaceView;
    private boolean mGamePaused;
    private boolean mGameCreated;
    private boolean mCreateGameCalled;
    private boolean mOnReloadResourcesScheduled;

    protected void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.mGamePaused = true;
        this.mEngine = this.onCreateEngine(this.onCreateEngineOptions());
        this.mEngine.startUpdateThread();
        this.applyEngineOptions();
        this.onSetContentView();
    }

    @Override
    public Engine onCreateEngine(EngineOptions pEngineOptions) {
        return new Engine(pEngineOptions);
    }

    @Override
    public synchronized void onSurfaceCreated(GLState pGLState) {
        if (this.mGameCreated) {
            this.onReloadResources();
            if (this.mGamePaused && this.mGameCreated) {
                this.onResumeGame();
            }
        } else if (this.mCreateGameCalled) {
            this.mOnReloadResourcesScheduled = true;
        } else {
            this.mCreateGameCalled = true;
            this.onCreateGame();
        }
    }

    @Override
    public synchronized void onSurfaceChanged(GLState pGLState, int pWidth, int pHeight) {
    }

    protected synchronized void onCreateGame() {
        final IGameInterface.OnPopulateSceneCallback onPopulateSceneCallback = new IGameInterface.OnPopulateSceneCallback(){

            @Override
            public void onPopulateSceneFinished() {
                try {
                    BaseGameActivity.this.onGameCreated();
                }
                catch (Throwable pThrowable) {
                    Debug.e(BaseGameActivity.this.getClass().getSimpleName() + ".onGameCreated failed." + " @(Thread: '" + Thread.currentThread().getName() + "')", pThrowable);
                }
                BaseGameActivity.this.callGameResumedOnUIThread();
            }
        };
        final IGameInterface.OnCreateSceneCallback onCreateSceneCallback = new IGameInterface.OnCreateSceneCallback(){

            @Override
            public void onCreateSceneFinished(Scene pScene) {
                BaseGameActivity.this.mEngine.setScene(pScene);
                try {
                    BaseGameActivity.this.onPopulateScene(pScene, onPopulateSceneCallback);
                }
                catch (Throwable pThrowable) {
                    Debug.e(BaseGameActivity.this.getClass().getSimpleName() + ".onPopulateScene failed." + " @(Thread: '" + Thread.currentThread().getName() + "')", pThrowable);
                }
            }
        };
        IGameInterface.OnCreateResourcesCallback onCreateResourcesCallback = new IGameInterface.OnCreateResourcesCallback(){

            @Override
            public void onCreateResourcesFinished() {
                try {
                    BaseGameActivity.this.onCreateScene(onCreateSceneCallback);
                }
                catch (Throwable pThrowable) {
                    Debug.e(BaseGameActivity.this.getClass().getSimpleName() + ".onCreateScene failed." + " @(Thread: '" + Thread.currentThread().getName() + "')", pThrowable);
                }
            }
        };
        try {
            this.onCreateResources(onCreateResourcesCallback);
        }
        catch (Throwable pThrowable) {
            Debug.e(this.getClass().getSimpleName() + ".onCreateGame failed." + " @(Thread: '" + Thread.currentThread().getName() + "')", pThrowable);
        }
    }

    @Override
    public synchronized void onGameCreated() {
        this.mGameCreated = true;
        if (this.mOnReloadResourcesScheduled) {
            this.mOnReloadResourcesScheduled = false;
            try {
                this.onReloadResources();
            }
            catch (Throwable pThrowable) {
                Debug.e(this.getClass().getSimpleName() + ".onReloadResources failed." + " @(Thread: '" + Thread.currentThread().getName() + "')", pThrowable);
            }
        }
    }

    protected synchronized void onResume() {
        super.onResume();
        this.acquireWakeLock();
        this.mRenderSurfaceView.onResume();
    }

    @Override
    public synchronized void onResumeGame() {
        this.mEngine.start();
        this.mGamePaused = false;
    }

    public synchronized void onWindowFocusChanged(boolean pHasWindowFocus) {
        super.onWindowFocusChanged(pHasWindowFocus);
        if (pHasWindowFocus && this.mGamePaused && this.mGameCreated) {
            this.onResumeGame();
        }
    }

    @Override
    public void onReloadResources() {
        this.mEngine.onReloadResources();
    }

    protected void onPause() {
        super.onPause();
        this.mRenderSurfaceView.onPause();
        this.releaseWakeLock();
        if (!this.mGamePaused) {
            this.onPauseGame();
        }
    }

    @Override
    public synchronized void onPauseGame() {
        this.mGamePaused = true;
        this.mEngine.stop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mEngine.onDestroy();
        try {
            this.onDestroyResources();
        }
        catch (Throwable pThrowable) {
            Debug.e(this.getClass().getSimpleName() + ".onDestroyResources failed." + " @(Thread: '" + Thread.currentThread().getName() + "')", pThrowable);
        }
        this.onGameDestroyed();
        this.mEngine = null;
    }

    @Override
    public void onDestroyResources() throws Exception {
        if (this.mEngine.getEngineOptions().getAudioOptions().needsMusic()) {
            this.getMusicManager().releaseAll();
        }
        if (this.mEngine.getEngineOptions().getAudioOptions().needsSound()) {
            this.getSoundManager().releaseAll();
        }
    }

    @Override
    public synchronized void onGameDestroyed() {
        this.mGameCreated = false;
    }

    public Engine getEngine() {
        return this.mEngine;
    }

    public boolean isGamePaused() {
        return this.mGamePaused;
    }

    public boolean isGameRunning() {
        return !this.mGamePaused;
    }

    public boolean isGameLoaded() {
        return this.mGameCreated;
    }

    public VertexBufferObjectManager getVertexBufferObjectManager() {
        return this.mEngine.getVertexBufferObjectManager();
    }

    public TextureManager getTextureManager() {
        return this.mEngine.getTextureManager();
    }

    public FontManager getFontManager() {
        return this.mEngine.getFontManager();
    }

    public ShaderProgramManager getShaderProgramManager() {
        return this.mEngine.getShaderProgramManager();
    }

    public SoundManager getSoundManager() {
        return this.mEngine.getSoundManager();
    }

    public MusicManager getMusicManager() {
        return this.mEngine.getMusicManager();
    }

    private void callGameResumedOnUIThread() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BaseGameActivity.this.onResumeGame();
            }
        });
    }

    protected void onSetContentView() {
        this.mRenderSurfaceView = new RenderSurfaceView((Context)this);
        this.mRenderSurfaceView.setRenderer(this.mEngine, this);
        this.setContentView((View)this.mRenderSurfaceView, (ViewGroup.LayoutParams)BaseGameActivity.createSurfaceViewLayoutParams());
    }

    public void runOnUpdateThread(Runnable pRunnable) {
        this.mEngine.runOnUpdateThread(pRunnable);
    }

    public void runOnUpdateThread(Runnable pRunnable, boolean pOnlyWhenEngineRunning) {
        this.mEngine.runOnUpdateThread(pRunnable, pOnlyWhenEngineRunning);
    }

    private void acquireWakeLock() {
        this.acquireWakeLock(this.mEngine.getEngineOptions().getWakeLockOptions());
    }

    private void acquireWakeLock(WakeLockOptions pWakeLockOptions) {
        if (pWakeLockOptions == WakeLockOptions.SCREEN_ON) {
            ActivityUtils.keepScreenOn((Activity)this);
        } else {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.mWakeLock = pm.newWakeLock(pWakeLockOptions.getFlag() | 0x20000000, "AndEngine");
            try {
                this.mWakeLock.acquire();
            }
            catch (SecurityException pSecurityException) {
                Debug.e("You have to add\n\t<uses-permission android:name=\"android.permission.WAKE_LOCK\"/>\nto your AndroidManifest.xml !", pSecurityException);
            }
        }
    }

    private void releaseWakeLock() {
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private void applyEngineOptions() {
        EngineOptions engineOptions = this.mEngine.getEngineOptions();
        if (engineOptions.isFullscreen()) {
            ActivityUtils.requestFullscreen((Activity)this);
        }
        if (engineOptions.getAudioOptions().needsMusic() || engineOptions.getAudioOptions().needsSound()) {
            this.setVolumeControlStream(3);
        }
        switch (engineOptions.getScreenOrientation()) {
            case LANDSCAPE_FIXED: {
                this.setRequestedOrientation(0);
                break;
            }
            case LANDSCAPE_SENSOR: {
                if (SystemUtils.SDK_VERSION_GINGERBREAD_OR_LATER) {
                    this.setRequestedOrientation(6);
                    break;
                }
                Debug.w(ScreenOrientation.class.getSimpleName() + "." + (Object)((Object)ScreenOrientation.LANDSCAPE_SENSOR) + " is not supported on this device. Falling back to " + ScreenOrientation.class.getSimpleName() + "." + (Object)((Object)ScreenOrientation.LANDSCAPE_FIXED));
                this.setRequestedOrientation(0);
                break;
            }
            case PORTRAIT_FIXED: {
                this.setRequestedOrientation(1);
                break;
            }
            case PORTRAIT_SENSOR: {
                if (SystemUtils.SDK_VERSION_GINGERBREAD_OR_LATER) {
                    this.setRequestedOrientation(7);
                    break;
                }
                Debug.w(ScreenOrientation.class.getSimpleName() + "." + (Object)((Object)ScreenOrientation.PORTRAIT_SENSOR) + " is not supported on this device. Falling back to " + ScreenOrientation.class.getSimpleName() + "." + (Object)((Object)ScreenOrientation.PORTRAIT_FIXED));
                this.setRequestedOrientation(1);
            }
        }
    }

    protected static FrameLayout.LayoutParams createSurfaceViewLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        return layoutParams;
    }

    protected void enableVibrator() {
        this.mEngine.enableVibrator((Context)this);
    }

    protected void enableLocationSensor(ILocationListener pLocationListener, LocationSensorOptions pLocationSensorOptions) {
        this.mEngine.enableLocationSensor((Context)this, pLocationListener, pLocationSensorOptions);
    }

    protected void disableLocationSensor() {
        this.mEngine.disableLocationSensor((Context)this);
    }

    protected boolean enableAccelerationSensor(IAccelerationListener pAccelerationListener) {
        return this.mEngine.enableAccelerationSensor((Context)this, pAccelerationListener);
    }

    protected boolean enableAccelerationSensor(IAccelerationListener pAccelerationListener, AccelerationSensorOptions pAccelerationSensorOptions) {
        return this.mEngine.enableAccelerationSensor((Context)this, pAccelerationListener, pAccelerationSensorOptions);
    }

    protected boolean disableAccelerationSensor() {
        return this.mEngine.disableAccelerationSensor((Context)this);
    }

    protected boolean enableOrientationSensor(IOrientationListener pOrientationListener) {
        return this.mEngine.enableOrientationSensor((Context)this, pOrientationListener);
    }

    protected boolean enableOrientationSensor(IOrientationListener pOrientationListener, OrientationSensorOptions pLocationSensorOptions) {
        return this.mEngine.enableOrientationSensor((Context)this, pOrientationListener, pLocationSensorOptions);
    }

    protected boolean disableOrientationSensor() {
        return this.mEngine.disableOrientationSensor((Context)this);
    }
}

