/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.ui.dialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import org.andengine.util.call.Callback;
import org.andengine.util.debug.Debug;

public abstract class GenericInputDialogBuilder<T> {
    protected final Callback<T> mSuccessCallback;
    protected final DialogInterface.OnCancelListener mOnCancelListener;
    protected final int mTitleResID;
    protected final int mMessageResID;
    protected final int mIconResID;
    protected final Context mContext;
    private final int mErrorResID;
    private final String mDefaultText;

    public GenericInputDialogBuilder(Context pContext, int pTitleResID, int pMessageResID, int pErrorResID, int pIconResID, Callback<T> pSuccessCallback, DialogInterface.OnCancelListener pOnCancelListener) {
        this(pContext, pTitleResID, pMessageResID, pErrorResID, pIconResID, "", pSuccessCallback, pOnCancelListener);
    }

    public GenericInputDialogBuilder(Context pContext, int pTitleResID, int pMessageResID, int pErrorResID, int pIconResID, String pDefaultText, Callback<T> pSuccessCallback, DialogInterface.OnCancelListener pOnCancelListener) {
        this.mContext = pContext;
        this.mTitleResID = pTitleResID;
        this.mMessageResID = pMessageResID;
        this.mErrorResID = pErrorResID;
        this.mIconResID = pIconResID;
        this.mDefaultText = pDefaultText;
        this.mSuccessCallback = pSuccessCallback;
        this.mOnCancelListener = pOnCancelListener;
    }

    protected abstract T generateResult(String var1);

    public Dialog create() {
        final EditText etInput = new EditText(this.mContext);
        etInput.setText((CharSequence)this.mDefaultText);
        AlertDialog.Builder ab = new AlertDialog.Builder(this.mContext);
        if (this.mTitleResID != 0) {
            ab.setTitle(this.mTitleResID);
        }
        if (this.mMessageResID != 0) {
            ab.setMessage(this.mMessageResID);
        }
        if (this.mIconResID != 0) {
            ab.setIcon(this.mIconResID);
        }
        this.setView(ab, etInput);
        ab.setOnCancelListener(this.mOnCancelListener).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface pDialog, int pWhich) {
                Object result;
                try {
                    result = GenericInputDialogBuilder.this.generateResult(etInput.getText().toString());
                }
                catch (IllegalArgumentException e) {
                    Debug.e("Error in GenericInputDialogBuilder.generateResult()", e);
                    Toast.makeText((Context)GenericInputDialogBuilder.this.mContext, (int)GenericInputDialogBuilder.this.mErrorResID, (int)0).show();
                    return;
                }
                GenericInputDialogBuilder.this.mSuccessCallback.onCallback(result);
                pDialog.dismiss();
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface pDialog, int pWhich) {
                GenericInputDialogBuilder.this.mOnCancelListener.onCancel(pDialog);
                pDialog.dismiss();
            }
        });
        return ab.create();
    }

    protected void setView(AlertDialog.Builder pBuilder, EditText pInputEditText) {
        pBuilder.setView((View)pInputEditText);
    }
}

