/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.view.Window;
import android.view.WindowManager;
import org.andengine.util.call.AsyncCallable;
import org.andengine.util.call.Callable;
import org.andengine.util.call.Callback;
import org.andengine.util.debug.Debug;
import org.andengine.util.exception.CancelledException;
import org.andengine.util.progress.IProgressListener;
import org.andengine.util.progress.ProgressCallable;

public class ActivityUtils {
    public static void requestFullscreen(Activity pActivity) {
        Window window = pActivity.getWindow();
        window.addFlags(1024);
        window.clearFlags(2048);
        window.requestFeature(1);
    }

    public static void setScreenBrightness(Activity pActivity, float pScreenBrightness) {
        Window window = pActivity.getWindow();
        WindowManager.LayoutParams windowLayoutParams = window.getAttributes();
        windowLayoutParams.screenBrightness = pScreenBrightness;
        window.setAttributes(windowLayoutParams);
    }

    public static void keepScreenOn(Activity pActivity) {
        pActivity.getWindow().addFlags(128);
    }

    public static <T> void doAsync(Context pContext, int pTitleResourceID, int pMessageResourceID, Callable<T> pCallable, Callback<T> pCallback) {
        ActivityUtils.doAsync(pContext, pTitleResourceID, pMessageResourceID, pCallable, pCallback, null, false);
    }

    public static <T> void doAsync(Context pContext, CharSequence pTitle, CharSequence pMessage, Callable<T> pCallable, Callback<T> pCallback) {
        ActivityUtils.doAsync(pContext, pTitle, pMessage, pCallable, pCallback, null, false);
    }

    public static <T> void doAsync(Context pContext, int pTitleResourceID, int pMessageResourceID, Callable<T> pCallable, Callback<T> pCallback, boolean pCancelable) {
        ActivityUtils.doAsync(pContext, pTitleResourceID, pMessageResourceID, pCallable, pCallback, null, pCancelable);
    }

    public static <T> void doAsync(Context pContext, CharSequence pTitle, CharSequence pMessage, Callable<T> pCallable, Callback<T> pCallback, boolean pCancelable) {
        ActivityUtils.doAsync(pContext, pTitle, pMessage, pCallable, pCallback, null, pCancelable);
    }

    public static <T> void doAsync(Context pContext, int pTitleResourceID, int pMessageResourceID, Callable<T> pCallable, Callback<T> pCallback, Callback<Exception> pExceptionCallback) {
        ActivityUtils.doAsync(pContext, pTitleResourceID, pMessageResourceID, pCallable, pCallback, pExceptionCallback, false);
    }

    public static <T> void doAsync(Context pContext, CharSequence pTitle, CharSequence pMessage, Callable<T> pCallable, Callback<T> pCallback, Callback<Exception> pExceptionCallback) {
        ActivityUtils.doAsync(pContext, pTitle, pMessage, pCallable, pCallback, pExceptionCallback, false);
    }

    public static <T> void doAsync(Context pContext, int pTitleResourceID, int pMessageResourceID, Callable<T> pCallable, Callback<T> pCallback, Callback<Exception> pExceptionCallback, boolean pCancelable) {
        ActivityUtils.doAsync(pContext, pContext.getString(pTitleResourceID), pContext.getString(pMessageResourceID), pCallable, pCallback, pExceptionCallback, pCancelable);
    }

    public static <T> void doAsync(final Context pContext, final CharSequence pTitle, final CharSequence pMessage, final Callable<T> pCallable, final Callback<T> pCallback, final Callback<Exception> pExceptionCallback, final boolean pCancelable) {
        new AsyncTask<Void, Void, T>(){
            private ProgressDialog mPD;
            private Exception mException = null;

            public void onPreExecute() {
                this.mPD = ProgressDialog.show((Context)pContext, (CharSequence)pTitle, (CharSequence)pMessage, (boolean)true, (boolean)pCancelable);
                if (pCancelable) {
                    this.mPD.setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface pDialogInterface) {
                            pExceptionCallback.onCallback(new CancelledException());
                            pDialogInterface.dismiss();
                        }
                    });
                }
                super.onPreExecute();
            }

            public T doInBackground(Void ... params) {
                try {
                    return pCallable.call();
                }
                catch (Exception e) {
                    this.mException = e;
                    return null;
                }
            }

            public void onPostExecute(T result) {
                try {
                    this.mPD.dismiss();
                }
                catch (Exception e) {
                    Debug.e("Error", e);
                }
                if (this.isCancelled()) {
                    this.mException = new CancelledException();
                }
                if (this.mException == null) {
                    pCallback.onCallback(result);
                } else if (pExceptionCallback == null) {
                    Debug.e("Error", this.mException);
                } else {
                    pExceptionCallback.onCallback(this.mException);
                }
                super.onPostExecute(result);
            }
        }.execute((Object[])null);
    }

    public static <T> void doProgressAsync(Context pContext, int pTitleResourceID, int pIconResourceID, ProgressCallable<T> pCallable, Callback<T> pCallback) {
        ActivityUtils.doProgressAsync(pContext, pTitleResourceID, pIconResourceID, pCallable, pCallback, null);
    }

    public static <T> void doProgressAsync(Context pContext, CharSequence pTitle, int pIconResourceID, ProgressCallable<T> pCallable, Callback<T> pCallback) {
        ActivityUtils.doProgressAsync(pContext, pTitle, pIconResourceID, pCallable, pCallback, null);
    }

    public static <T> void doProgressAsync(Context pContext, int pTitleResourceID, int pIconResourceID, ProgressCallable<T> pCallable, Callback<T> pCallback, Callback<Exception> pExceptionCallback) {
        ActivityUtils.doProgressAsync(pContext, pContext.getString(pTitleResourceID), pIconResourceID, pCallable, pCallback, pExceptionCallback);
    }

    public static <T> void doProgressAsync(final Context pContext, final CharSequence pTitle, final int pIconResourceID, final ProgressCallable<T> pCallable, final Callback<T> pCallback, final Callback<Exception> pExceptionCallback) {
        new AsyncTask<Void, Integer, T>(){
            private ProgressDialog mPD;
            private Exception mException = null;

            public void onPreExecute() {
                this.mPD = new ProgressDialog(pContext);
                this.mPD.setTitle(pTitle);
                this.mPD.setIcon(pIconResourceID);
                this.mPD.setIndeterminate(false);
                this.mPD.setProgressStyle(1);
                this.mPD.show();
                super.onPreExecute();
            }

            public T doInBackground(Void ... params) {
                try {
                    return pCallable.call(new IProgressListener(){

                        @Override
                        public void onProgressChanged(int pProgress) {
                            this.onProgressUpdate(pProgress);
                        }
                    });
                }
                catch (Exception e) {
                    this.mException = e;
                    return null;
                }
            }

            public void onProgressUpdate(Integer ... values) {
                this.mPD.setProgress(values[0].intValue());
            }

            public void onPostExecute(T result) {
                try {
                    this.mPD.dismiss();
                }
                catch (Exception e) {
                    Debug.e("Error", e);
                }
                if (this.isCancelled()) {
                    this.mException = new CancelledException();
                }
                if (this.mException == null) {
                    pCallback.onCallback(result);
                } else if (pExceptionCallback == null) {
                    Debug.e("Error", this.mException);
                } else {
                    pExceptionCallback.onCallback(this.mException);
                }
                super.onPostExecute(result);
            }
        }.execute((Object[])null);
    }

    public static <T> void doAsync(Context pContext, int pTitleResourceID, int pMessageResourceID, AsyncCallable<T> pAsyncCallable, Callback<T> pCallback, Callback<Exception> pExceptionCallback) {
        ActivityUtils.doAsync(pContext, (CharSequence)pContext.getString(pTitleResourceID), (CharSequence)pContext.getString(pMessageResourceID), pAsyncCallable, pCallback, pExceptionCallback);
    }

    public static <T> void doAsync(Context pContext, CharSequence pTitle, CharSequence pMessage, AsyncCallable<T> pAsyncCallable, final Callback<T> pCallback, Callback<Exception> pExceptionCallback) {
        final ProgressDialog pd = ProgressDialog.show((Context)pContext, (CharSequence)pTitle, (CharSequence)pMessage);
        pAsyncCallable.call(new Callback<T>(){

            @Override
            public void onCallback(T result) {
                try {
                    pd.dismiss();
                }
                catch (Exception e) {
                    Debug.e("Error", e);
                }
                pCallback.onCallback(result);
            }
        }, pExceptionCallback);
    }
}

