/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import java.util.GregorianCalendar;
import org.andengine.util.preferences.SimplePreferences;

public class BetaUtils {
    private static final String PREFERENCES_BETAUTILS_ID = "preferences.betautils.lastuse";

    public static boolean finishWhenExpired(Activity pActivity, GregorianCalendar pExpirationDate, int pTitleResourceID, int pMessageResourceID) {
        return BetaUtils.finishWhenExpired(pActivity, pExpirationDate, pTitleResourceID, pMessageResourceID, null, null);
    }

    public static boolean finishWhenExpired(final Activity pActivity, GregorianCalendar pExpirationDate, int pTitleResourceID, int pMessageResourceID, final Intent pOkIntent, final Intent pCancelIntent) {
        SharedPreferences spref = SimplePreferences.getInstance((Context)pActivity);
        long now = System.currentTimeMillis();
        long lastuse = Math.max(now, spref.getLong(PREFERENCES_BETAUTILS_ID, -1L));
        spref.edit().putLong(PREFERENCES_BETAUTILS_ID, lastuse).commit();
        GregorianCalendar lastuseDate = new GregorianCalendar();
        lastuseDate.setTimeInMillis(lastuse);
        if (lastuseDate.after(pExpirationDate)) {
            AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder((Context)pActivity).setTitle(pTitleResourceID).setIcon(17301543).setMessage(pMessageResourceID);
            alertDialogBuilder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface pDialog, int pWhich) {
                    if (pOkIntent != null) {
                        pActivity.startActivity(pOkIntent);
                    }
                    pActivity.finish();
                }
            });
            alertDialogBuilder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface pDialog, int pWhich) {
                    if (pCancelIntent != null) {
                        pActivity.startActivity(pCancelIntent);
                    }
                    pActivity.finish();
                }
            }).create().show();
            return true;
        }
        return false;
    }
}

