/*
 * Decompiled with CFR 0.152.
 */
package org.andengine.util;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import org.andengine.util.StreamUtils;

public class FileUtils {
    public static void copyToExternalStorage(Context pContext, int pSourceResourceID, String pFilename) throws FileNotFoundException {
        FileUtils.copyToExternalStorage(pContext, pContext.getResources().openRawResource(pSourceResourceID), pFilename);
    }

    public static void copyToInternalStorage(Context pContext, int pSourceResourceID, String pFilename) throws FileNotFoundException {
        FileUtils.copyToInternalStorage(pContext, pContext.getResources().openRawResource(pSourceResourceID), pFilename);
    }

    public static void copyToExternalStorage(Context pContext, String pSourceAssetPath, String pFilename) throws IOException {
        FileUtils.copyToExternalStorage(pContext, pContext.getAssets().open(pSourceAssetPath), pFilename);
    }

    public static void copyToInternalStorage(Context pContext, String pSourceAssetPath, String pFilename) throws IOException {
        FileUtils.copyToInternalStorage(pContext, pContext.getAssets().open(pSourceAssetPath), pFilename);
    }

    private static void copyToInternalStorage(Context pContext, InputStream pInputStream, String pFilename) throws FileNotFoundException {
        StreamUtils.copyAndClose(pInputStream, new FileOutputStream(new File(pContext.getFilesDir(), pFilename)));
    }

    public static void copyToExternalStorage(InputStream pInputStream, String pFilePath) throws FileNotFoundException {
        if (!FileUtils.isExternalStorageWriteable()) {
            throw new IllegalStateException("External Storage is not writeable.");
        }
        String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pFilePath);
        StreamUtils.copyAndClose(pInputStream, new FileOutputStream(absoluteFilePath));
    }

    public static void copyToExternalStorage(Context pContext, InputStream pInputStream, String pFilePath) throws FileNotFoundException {
        if (!FileUtils.isExternalStorageWriteable()) {
            throw new IllegalStateException("External Storage is not writeable.");
        }
        String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pFilePath);
        StreamUtils.copyAndClose(pInputStream, new FileOutputStream(absoluteFilePath));
    }

    public static boolean isFileExistingOnExternalStorage(String pFilePath) {
        if (FileUtils.isExternalStorageReadable()) {
            String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pFilePath);
            File file = new File(absoluteFilePath);
            return file.exists() && file.isFile();
        }
        throw new IllegalStateException("External Storage is not readable.");
    }

    public static boolean isFileExistingOnExternalStorage(Context pContext, String pFilePath) {
        if (FileUtils.isExternalStorageReadable()) {
            String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pFilePath);
            File file = new File(absoluteFilePath);
            return file.exists() && file.isFile();
        }
        throw new IllegalStateException("External Storage is not readable.");
    }

    public static boolean isDirectoryExistingOnExternalStorage(Context pContext, String pDirectory) {
        if (FileUtils.isExternalStorageReadable()) {
            String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pDirectory);
            File file = new File(absoluteFilePath);
            return file.exists() && file.isDirectory();
        }
        throw new IllegalStateException("External Storage is not readable.");
    }

    public static boolean ensureDirectoriesExistOnExternalStorage(Context pContext, String pDirectory) {
        if (FileUtils.isDirectoryExistingOnExternalStorage(pContext, pDirectory)) {
            return true;
        }
        if (FileUtils.isExternalStorageWriteable()) {
            String absoluteDirectoryPath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pDirectory);
            return new File(absoluteDirectoryPath).mkdirs();
        }
        throw new IllegalStateException("External Storage is not writeable.");
    }

    public static InputStream openOnExternalStorage(String pFilePath) throws FileNotFoundException {
        String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pFilePath);
        return new FileInputStream(absoluteFilePath);
    }

    public static InputStream openOnExternalStorage(Context pContext, String pFilePath) throws FileNotFoundException {
        String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pFilePath);
        return new FileInputStream(absoluteFilePath);
    }

    public static String[] getDirectoryListOnExternalStorage(Context pContext, String pFilePath) {
        String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pFilePath);
        return new File(absoluteFilePath).list();
    }

    public static String[] getDirectoryListOnExternalStorage(Context pContext, String pFilePath, FilenameFilter pFilenameFilter) {
        String absoluteFilePath = FileUtils.getAbsolutePathOnExternalStorage(pContext, pFilePath);
        return new File(absoluteFilePath).list(pFilenameFilter);
    }

    public static String getAbsolutePathOnInternalStorage(Context pContext, String pFilePath) {
        return pContext.getFilesDir().getAbsolutePath() + pFilePath;
    }

    public static String getAbsolutePathOnExternalStorage(String pFilePath) {
        return Environment.getExternalStorageDirectory() + "/" + pFilePath;
    }

    public static String getAbsolutePathOnExternalStorage(Context pContext, String pFilePath) {
        return Environment.getExternalStorageDirectory() + "/Android/data/" + pContext.getApplicationInfo().packageName + "/files/" + pFilePath;
    }

    public static boolean isExternalStorageWriteable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return state.equals("mounted") || state.equals("mounted_ro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File pSourceFile, File pDestinationFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(pSourceFile);
            out = new FileOutputStream(pDestinationFile);
            StreamUtils.copy((InputStream)in, out);
        }
        catch (Throwable throwable) {
            StreamUtils.close(in);
            StreamUtils.close(out);
            throw throwable;
        }
        StreamUtils.close(in);
        StreamUtils.close(out);
    }

    public static boolean deleteDirectory(File pFileOrDirectory) {
        if (pFileOrDirectory.isDirectory()) {
            String[] children = pFileOrDirectory.list();
            int childrenCount = children.length;
            for (int i = 0; i < childrenCount; ++i) {
                boolean success = FileUtils.deleteDirectory(new File(pFileOrDirectory, children[i]));
                if (success) continue;
                return false;
            }
        }
        return pFileOrDirectory.delete();
    }
}

